% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multialign.R
\name{msa2mat}
\alias{msa2mat}
\title{Convert alignment to matrix}
\usage{
msa2mat(msa)
}
\arguments{
\item{msa}{A fasta object with a multiple alignment, see \code{\link{msalign}}`.}
}
\value{
A \code{matrix} where each row is a vector of aligned bases/amino acids.
}
\description{
Converts a FASTA formatted multiple alignment to a matrix.
}
\details{
This function converts the fasta object \code{msa}, containing a multiple alignment,
to a matrix. This means each position in the alignment is a column in the matrix, and the
content of the \samp{Header} column of \code{msa} is used as rownames of theh matrix.

Such a matrix is useful for conversion to a \code{DNAbin} object that is used by the \code{ape}
package for re-constructing phylogenetic trees.
}
\examples{
msa.file <- file.path(path.package("microseq"),"extdata", "small.msa")
msa <- readFasta(msa.file)
msa.mat <- msa2mat(msa)  # to use with ape::as.DNAbin(msa.mat)

}
\seealso{
\code{\link{msalign}}, \code{\link{readFasta}}.
}
\author{
Lars Snipen.
}
