% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpret.R
\name{ma_interpret}
\alias{ma_interpret}
\title{Interpret API}
\usage{
ma_interpret(query, count = 10, offset = 0, complete = TRUE, key = NULL, ...)
}
\arguments{
\item{query}{(character) query terms}

\item{count}{(intger) number of records to return. default: 10}

\item{offset}{(intger) record number to start at. default: 0}

\item{complete}{(logical) \code{TRUE} means that auto-completion suggestions
are generated based on the grammar and graph data. default: \code{TRUE}}

\item{key}{(character) microsoft academic API key, see the \code{Authentication}
section in \link{microdemic-package}}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Interpret API
}
\examples{
\dontrun{
res <- ma_interpret(query = "papers by jaime'...")
res$query
res$interpretations
res$interpretations$parse
res$interpretations$rules
res$interpretations$rules[[1]]

expr <- res$interpretations$rules[[1]]$output.value
ma_evaluate(expr)
}
}
\references{
https://docs.microsoft.com/en-us/academic-services/project-academic-knowledge/reference-interpret-method
}
