% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CV_results.R
\name{CV_results}
\alias{CV_results}
\title{Compute the error or plot the stability values after \code{\link[=CV_iterative_clustering]{CV_iterative_clustering()}}.}
\usage{
CV_results(
  data,
  cv_klist,
  output = "MAE",
  points = TRUE,
  k = 1L,
  size_line = 0.5
)
}
\arguments{
\item{data}{input matrix with paired times, i.e. samples to be stressed to multiple iterations.}

\item{cv_klist}{list resulting from \code{\link[=CV_iterative_clustering]{CV_iterative_clustering()}}.}

\item{output}{character: MAE or viz; to return a data frame with the MAE or to visualize a line plot.}

\item{points}{logical; if plotting, FALSE to only plot lines and TRUE to add points on the original stability value, i.e. result from \code{\link[=stabilitas]{stabilitas()}}.}

\item{k}{integer; number of individuals to subset from the data. The same as used in \code{\link[=CV_iterative_clustering]{CV_iterative_clustering()}}.}

\item{size_line}{numeric; if plotting, size of the multiple lines.}
}
\value{
A vector with MAE values or a line plot  in the form of a "ggplot" object with the values of stability for the multiple subsets and the original matrix of paired samples.
}
\description{
Compute the mean absolute error after the cross validation or plot lines connecting the stability values for each subset of the original matrix of paired times.
}
\examples{
\donttest{
t1_t2 <- paired_times(data = clr, first = "_1",
                      second = "_25", common = "_0_")
klist_t1_t2 <- iterative_clustering(data = t1_t2, parallel = FALSE)
result_t1_t2 <- stabilitas(klist_t1_t2, common = "_0_")
cv_klist_t1_t2_k2 <- CV_iterative_clustering(data = t1_t2, results = result_t1_t2,
                                             common = "_0_", k = 2L, parallel = FALSE)
MAE_t1_t2 <- CV_results(data = t1_t2, cv_klist = cv_klist_t1_t2_k2,
                       output = "MAE", k = 2L)
MAE <- st_previz(results = list(MAE_t1_t2),
                 times = "MAE_t1_t2")
st_heatmap(data = MAE, label = TRUE,
           high = 'red2', midpoint = 0.075, low = 'forestgreen')
CV_results(data = t1_t2, cv_klist = cv_klist_t1_t2_k2,
           output = "viz", k = 2L)
}
}
