% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix.coef.R
\name{fix.coef}
\alias{fix.coef}
\title{Fix coefficients and update model}
\usage{
fix.coef(model, beta = NULL)
}
\arguments{
\item{model}{An R model, e.g., produced by \code{lm} or \code{glm}}

\item{beta}{A numeric vector with \code{length(coef)} model coefficients. 
If the vector is not named, the coefficients should be
given in the same order as in \code{coef(model)}. If the vector is named,
the procedure attempts to match on names.}
}
\value{
An updated R model object
}
\description{
Refits a model with a specified set of coefficients.
}
\details{
The function calculates the linear predictor using the new coefficients, 
and reformulates the model using the \code{offset} 
argument. The linear predictor is called 
\code{offset}, and its coefficient will be \code{1} by definition. 
The new model only fits the intercept, which should be \code{0} 
if we set \code{beta = coef(model)}.
}
\examples{
model0 <- lm(Volume ~ Girth + Height, data = trees)
formula(model0)
coef(model0)
deviance(model0)

# refit same model
model1 <- fix.coef(model0)
formula(model1)
coef(model1)
deviance(model1)

# change the beta's
model2 <- fix.coef(model0, beta = c(-50, 5, 1))
coef(model2)
deviance(model2)

# compare predictions
plot(predict(model0), predict(model1)); abline(0,1)
plot(predict(model0), predict(model2)); abline(0,1)

# compare proportion explained variance
cor(predict(model0), predict(model0) + residuals(model0))^2
cor(predict(model1), predict(model1) + residuals(model1))^2
cor(predict(model2), predict(model2) + residuals(model2))^2

# extract offset from constrained model
summary(model2$model$offset)

# it also works with factors and missing data
model0 <- lm(bmi ~ age + hyp + chl, data = nhanes2)
model1 <- fix.coef(model0)
model2 <- fix.coef(model0, beta = c(15, -8, -8, 2, 0.2))
}
\author{
Stef van Buuren, 2018
}
