% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mice.impute.norm.predict.R
\name{mice.impute.norm.predict}
\alias{mice.impute.norm.predict}
\alias{norm.predict}
\title{Imputation by linear regression through prediction}
\usage{
mice.impute.norm.predict(y, ry, x, wy = NULL, ridge = 1e-05, ...)
}
\arguments{
\item{y}{Vector to be imputed}

\item{ry}{Logical vector of length \code{length(y)} indicating the 
the subset \code{y[ry]} of elements in \code{y} to which the imputation 
model is fitted. The \code{ry} generally distinguishes the observed 
(\code{TRUE}) and missing values (\code{FALSE}) in \code{y}.}

\item{x}{Numeric design matrix with \code{length(y)} rows with predictors for 
\code{y}. Matrix \code{x} may have no missing values.}

\item{wy}{Logical vector of length \code{length(y)}. A \code{TRUE} value 
indicates locations in \code{y} for which imputations are created.}

\item{ridge}{The ridge penalty used in \code{.norm.draw()} to prevent 
problems with multicollinearity. The default is \code{ridge = 1e-05}, 
which means that 0.01 percent of the diagonal is added to the cross-product. 
Larger ridges may result in more biased estimates. For highly noisy data 
(e.g. many junk variables), set \code{ridge = 1e-06} or even lower to 
reduce bias. For highly collinear data, set \code{ridge = 1e-04} or higher.}

\item{...}{Other named arguments.}
}
\value{
Vector with imputed data, same type as \code{y}, and of length 
\code{sum(wy)}
}
\description{
Imputes the "best value" according to the linear regression model, also 
known as \emph{regression imputation}.
}
\details{
Calculates regression weights from the observed data and returns predicted
values to as imputations. The \code{ridge} parameter adds a penalty term
\code{ridge*diag(xtx)} to the variance-covariance matrix \code{xtx}. This
method is known as \emph{regression imputation}.
}
\section{Warning}{
 THIS METHOD SHOULD NOT BE USED FOR DATA ANALYSIS. 
This method is seductive because it imputes the most 
likely value according to the model. However, it ignores the uncertainty
of the missing values and artificially 
amplifies the relations between the columns of the data. Application of 
richer models having more parameters does not help to evade these issues. 
Stochastic regression methods, like \code{\link{mice.impute.pmm}} or 
\code{\link{mice.impute.norm}}, are generally preferred. 

At best, prediction can give reasonable estimates of the mean, especially 
if normality assumptions are plausible. See Little and Rubin (2002, p. 62-64)
or Van Buuren (2012, p. 11-13, p. 45-46) for a discussion of this method.
}

\references{
Little, R.J.A. and Rubin, D.B. (2002). Statistical Analysis with Missing 
Data.  New York: John Wiley and Sons.

Van Buuren, S. (2018). 
\href{https://stefvanbuuren.name/fimd/sec-linearnormal.html}{\emph{Flexible Imputation of Missing Data. Second Edition.}}
Chapman & Hall/CRC. Boca Raton, FL.
}
\seealso{
Other univariate imputation functions: \code{\link{mice.impute.cart}},
  \code{\link{mice.impute.lda}},
  \code{\link{mice.impute.logreg.boot}},
  \code{\link{mice.impute.logreg}},
  \code{\link{mice.impute.mean}},
  \code{\link{mice.impute.midastouch}},
  \code{\link{mice.impute.norm.boot}},
  \code{\link{mice.impute.norm.nob}},
  \code{\link{mice.impute.norm}},
  \code{\link{mice.impute.pmm}},
  \code{\link{mice.impute.polr}},
  \code{\link{mice.impute.polyreg}},
  \code{\link{mice.impute.quadratic}},
  \code{\link{mice.impute.rf}},
  \code{\link{mice.impute.ri}}
}
\author{
Stef van Buuren, 2011
}
\keyword{datagen}
