% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/target_mirna.R
\name{plot_target_count}
\alias{plot_target_count}
\title{Plot count of miRNA targets}
\usage{
plot_target_count(
  df,
  top = NULL,
  threshold = NULL,
  colour = "steelblue3",
  col.target = Target,
  title = NULL
)
}
\arguments{
\item{df}{Data frame with miRNA targets.}

\item{top}{Numeric. Specifies number of top targets to be plotted.}

\item{threshold}{Numeric. Specifies how often a target must be in \code{col.target}
to be plotted.}

\item{colour}{String. Colour of bar plot.}

\item{col.target}{Symbol. Column containing miRNA targets.}

\item{title}{String. Plot title.}
}
\value{
Bar plot with target counts.
}
\description{
Plot count of miRNA targets.
}
\details{
Plot count of miRNA targets as a bar plot. How many
targets are plotted is determined either by the \code{top} or by
the \code{threshold} argument.
If \code{top} is given, targets with the highest count are plotted.
Ties among targets with the highest count are treated as
the same rank, e.g. if \emph{PTEN}, \emph{AKT}, and \emph{VEGFA} all had the highest count,
they would all be plotted by specifying \code{top = 1}, \code{top = 2},
and \code{top = 3}.
If \code{threshold} is given, only targets with a count of at least \code{threshold}
are plotted.
If neither \code{top} nor \code{threshold} is given, \code{top} is automatically set
to \code{5}.
}
\seealso{
\code{\link[=count_target]{count_target()}}, \code{\link[=join_targets]{join_targets()}}

Other target functions: 
\code{\link{count_target}()},
\code{\link{join_mirtarbase}()},
\code{\link{join_targets}()},
\code{\link{plot_target_mir_scatter}()}
}
\concept{target functions}
