% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosswalks.R
\name{convert_to_marker_id}
\alias{convert_to_marker_id}
\title{Convert marker symbols to updated marker identifiers}
\usage{
convert_to_marker_id(x, rpt)
}
\arguments{
\item{x}{A character vector of marker symbols to be remapped.}

\item{rpt}{Report data as a \link[tibble:tibble-package]{tibble} offering the
translation table between old (\code{marker_symbol}) symbols and new
(\code{marker_id_now}) marker identifiers. Hence, at least, the following two columns
are required because they encode the mapping:
\itemize{
\item \code{marker_symbol}: The symbols to matched against the values of \code{x}.
\item \code{marker_id_now}: The new marker identifiers to be returned in case of a match.
}

Almost always, \code{rpt} will take the result of \code{read_report("marker_list1")}.}
}
\value{
A character vector of most up to date marker identifiers.
}
\description{
\code{\link[=convert_to_marker_id]{convert_to_marker_id()}} remaps old marker symbols to, in-use, most up to date
marker identifiers.
}
\examples{
# Reading only the first 100 markers (for efficiency)
rpt <- read_report("marker_list1", n_max = 100)
head(rpt)

# Note that:
#   - "0610005A07Rik" is a withdrawn symbol, so gets remapped to Gstm7.
#   - "0610005C13Rik" is an official symbol, so stays the same.
#   - "not a symbol" is not an existing symbol in `rpt`, so gets mapped to `NA`.
symbols <- c("0610005A07Rik", "0610005C13Rik", "not a symbol")
convert_to_marker_id(x = symbols, rpt = rpt)

}
