#' obs1: simulated observed data
#'
#' @format a dataframe with 3000 rows and 8 variables
#'  \describe{
#'     \item{ID}{individual id number}
#'     \item{Y}{true response, factor variable}
#'     \item{X}{true error-prone covariate, factor variable}
#'     \item{treatment}{error-free covariate}
#'     \item{visit}{serial number of each visit}
#'     \item{S}{observed response, same as Y when in the validation set(delta=1)}
#'     \item{W}{observed error-prone covariate, same as X when in the validation
#'              set (delta=1)}
#'     \item{delta}{indicator variable, 1 if in the validation set, 0 if not.}
#'    }
"obs1"

#' heart: preprocessed Framingham Heart Study Teaching data
#'
#' @format a dataframe with 1830 rows and 42 variables, a total of 915 participants.
#'  \describe{
#'     \item{RANDID}{individual id number}
#'     \item{HBP}{a factor variable derived from SYSBP. HBP=0 indicates SBP below
#'      140 mmHg, HBP=1 indicates SBP between 140 mmHg and 159 mmHg, and HBP=2 
#'      indicates SBP larger than 160 mmHg}
#'     \item{chol}{a factor variable derived from TOTCHOL.  
#'     0=normal (less than 200 mg/dL), 
#'     1=borderline high (200-239mg/dL), 
#'     2=hypercholesterolemia (greater than 240 mg/dL)}
#'     \item{exam3}{a factor variable. 1 if the observation belongs to exam 3, 0 otherwise.}
#'     
#'     For all other variables, please refer to https://biolincc.nhlbi.nih.gov/media/teachingstudies/FHS_Teaching_Longitudinal_Data_Documentation.pdf?link_time=2021-03-17_16:09:25.977880,
#'     The full teaching data set can be requested from https://biolincc.nhlbi.nih.gov/teaching/
#'     }
#' @details{
#'     The authors thank Boston University and the National Heart, Lung, and Blood Institute (NHLBI) for providing the data set from the Framingham Heart
#'     Study (No. N01-HC-25195) in the illustration. The Framingham Heart Study is conducted and supported by the NHLBI in collaboration with 
#'     Boston University. This package was not prepared in collaboration with investigators of the Framingham Heart Study and 
#'     does not necessarily reflect the opinions or views of the Framingham Heart Study, Boston University, or NHLBI. }
#'     
#' @references{
#'     Z. Chen, G. Y. YI, and C. WU. (2011) Marginal methods for correlated binary data with misclassified responses. \emph{Biometrika} 98(3):647-662, 2011
#'     
#'     Z. Chen, G. Y. Yi, and C. Wu. (2014) Marginal analysis of longitudinal ordinal data with misclassification inboth response and covariates. \emph{Biometrical Journal}, 56(1):69-85, Oct. 2014
#'     
#'     Carroll, R.J., Ruppert, D., Stefanski, L.A. and Crainiceanu, C. (2006) Measurement error in nonlinear models: A modern perspective., Second Edition. London: Chapman and Hall.
#'     }
#' @examples{
#'     data(heart)
#'     #Example 1:
#'     heart$chol = as.factor(heart$chol)
#'     heart$exam3 = as.factor(heart$exam3)
#'     ## set misclassification parameters to be known.
#'     varphiMat <- gamMat <- log( cbind(0.04/0.95, 0.01/0.95,
#'                                       0.95/0.03, 0.02/0.03,
#'                                       0.04/0.01, 0.95/0.01) )
#'     mgee2k.fit = mgee2k(formula = HBP~chol+AGE+CURSMOKE+exam3, id = "RANDID",
#'                         data = heart,
#'                         corstr = "exchangeable", misvariable = "chol", 
#'                         gamMat = gamMat,
#'                         varphiMat = varphiMat)
#'     summary(mgee2k.fit)
#'     
#'     #Example 2:
#'     naigee.fit = ordGEE2(formula = HBP~chol+AGE+CURSMOKE+exam3, id = "RANDID",
#'     data = heart, corstr = "exchangeable")
#'     summary(naigee.fit)
#'     }
"heart"
