% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemset.R
\name{itemset}
\alias{itemset}
\alias{itemset.default}
\alias{itemset.formula}
\title{Itemset Meta-features}
\usage{
itemset(...)

\method{itemset}{default}(x, y, features = "all", summary = c("mean", "sd"), ...)

\method{itemset}{formula}(formula, data, features = "all", summary = c("mean", "sd"), ...)
}
\arguments{
\item{...}{Further arguments passed to the summarization functions.}

\item{x}{A data.frame contained only the input attributes.}

\item{y}{A factor response vector with one label for each row/component of x.}

\item{features}{A list of features names or \code{"all"} to include all them.}

\item{summary}{A list of summarization functions or empty for all values. See
\link{post.processing} method to more information. (Default: 
\code{c("mean", "sd")})}

\item{formula}{A formula to define the class column.}

\item{data}{A data.frame dataset contained the input attributes and class.
The details section describes the valid values for this group.}
}
\value{
A list named by the requested meta-features.
}
\description{
Itemset characterization features measure measure the distribution of values 
of both single attributes and pairs of attributes.
}
\details{
The following features are allowed for this method:
 \describe{
   \item{"oneitemset"}{Individual frequency of each attributes' value.}
   \item{"twoitemset"}{Correlation information of the two attributes' 
     value pairs.}
   \item{"clssitemset"}{It is a two itemset computed using a predictive 
     attribute and the target.}
 }
}
\examples{
## Extract all meta-features using formula
itemset(Species ~ ., iris)

## Extract some meta-features
itemset(iris[1:4], iris[5], c("oneitemset"))

## Use another summarization function
itemset(Species ~ ., iris, summary=c("min", "median", "max"))
}
\references{
Song, Q., Wang, G., & Wang, C. (2012). Automatic recommendation of 
  classification algorithms based on data set characteristics. Pattern 
  Recognition, 45(7), 2672-2689.
  
Wang, G., Song, Q., & Zhu, X. (2015). An improved data characterization 
  method and its application in classification algorithm recommendation. 
  Applied Intelligence, 43(4), 892-912.
}
\seealso{
Other meta-features: 
\code{\link{clustering}()},
\code{\link{complexity}()},
\code{\link{concept}()},
\code{\link{general}()},
\code{\link{infotheo}()},
\code{\link{landmarking}()},
\code{\link{model.based}()},
\code{\link{relative}()},
\code{\link{statistical}()}
}
\concept{meta-features}
