% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval.R
\name{eval_psi_MargPost}
\alias{eval_psi_MargPost}
\title{Evaluate the marginal posterior of psi}
\usage{
eval_psi_MargPost(Pi_array, Sigma_array, Z_array, post_psi_center,
  prior_psi_mean, prior_psi_Omega, D_mat, n_determ, n_vars, n_lags, n_reps)
}
\arguments{
\item{Pi_array}{Array of draws of Pi from the Gibbs sampler.}

\item{Sigma_array}{Array of draws of Sigma from the Gibbs sampler.}

\item{Z_array}{The array of draws of Z from the Gibbs sampler.}

\item{post_psi_center}{The value at which to do the evaluation (e.g. the posterior mean/median).}

\item{prior_psi_mean}{Vector of length \code{n_determ*n_vars} with the prior means of the steady-state parameters.}

\item{prior_psi_Omega}{Matrix of size \code{(n_determ*n_vars) * (n_determ*n_vars)} with the prior covariance of the steady-state parameters.}

\item{D_mat}{The \code{D} matrix (from \code{\link{build_DD}}).}

\item{n_determ}{The number of deterministic terms.}

\item{n_vars}{The number of variables.}

\item{n_lags}{The number of lags.}

\item{n_reps}{The number of replications.}
}
\value{
The return is:
\item{evals}{A vector with the evaulations.}
}
\description{
Evaluates the marginal posterior of psi using the draws from the Gibbs sampler.
}
\keyword{internal}
