% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor.R
\name{random.cif}
\alias{random.cif}
\title{Random effects model for competing risks data}
\usage{
random.cif(
  cif,
  data,
  cause = NULL,
  cif2 = NULL,
  cause1 = 1,
  cause2 = 1,
  cens.code = NULL,
  cens.model = "KM",
  Nit = 40,
  detail = 0,
  clusters = NULL,
  theta = NULL,
  theta.des = NULL,
  sym = 1,
  step = 1,
  same.cens = FALSE,
  var.link = 0,
  score.method = "nr",
  entry = NULL,
  trunkp = 1,
  ...
)
}
\arguments{
\item{cif}{a model object from the comp.risk function with the 
marginal cumulative incidence of cause2, i.e., the event that is conditioned on, and whose
odds the comparision is made with respect to}

\item{data}{a data.frame with the variables.}

\item{cause}{specifies the causes  related to the death
times, the value cens.code is the censoring value.}

\item{cif2}{specificies model for cause2 if different from cause1.}

\item{cause1}{cause of first coordinate.}

\item{cause2}{cause of second coordinate.}

\item{cens.code}{specificies the code for the censoring if NULL then uses the one from the marginal cif model.}

\item{cens.model}{specified which model to use for the ICPW, KM is Kaplan-Meier alternatively it may be "cox"}

\item{Nit}{number of iterations for Newton-Raphson algorithm.}

\item{detail}{if 0 no details are printed during iterations, if 1 details are given.}

\item{clusters}{specifies the cluster structure.}

\item{theta}{specifies starting values for the cross-odds-ratio parameters of the model.}

\item{theta.des}{specifies a regression design for the cross-odds-ratio parameters.}

\item{sym}{1 for symmetry 0 otherwise}

\item{step}{specifies the step size for the Newton-Raphson algorith.m}

\item{same.cens}{if true then censoring within clusters are assumed to be the same variable, default is independent censoring.}

\item{var.link}{if var.link=1 then var is on log-scale.}

\item{score.method}{default uses "nlminb" optimzer, alternatively, use the "nr" algorithm.}

\item{entry}{entry-age in case of delayed entry. Then two causes must be given.}

\item{trunkp}{gives probability of survival for delayed entry, and related to entry-ages given above.}

\item{...}{extra arguments.}
}
\value{
returns an object of type 'cor'. With the following arguments:
\item{theta}{estimate of proportional odds parameters of model.}
\item{var.theta}{variance for gamma.  }
\item{hess}{the derivative of the used score.}
\item{score}{scores at final stage.}
\item{score}{scores at final stage.}
\item{theta.iid}{matrix of iid decomposition of parametric effects.}
}
\description{
Fits a random effects  model describing the dependence in the cumulative 
incidence curves for subjects within a cluster.  Given the gamma distributed
random effects it is assumed that the cumulative incidence curves are indpendent, and
that the marginal cumulative incidence curves are on the form
\deqn{
P(T \leq t, cause=1 | x,z) = P_1(t,x,z) = 1- exp( -x^T A(t) exp(z^T \beta))
}
We allow a regression structure for the random effects variances that may depend on
cluster covariates.
}
\examples{
\donttest{ ## Reduce Ex.Timings
 d <- simnordic.random(5000,delayed=TRUE,cordz=0.5,cormz=2,lam0=0.3,country=TRUE)
 times <- seq(50,90,by=10)
 add1 <- timereg::comp.risk(Event(time,cause)~-1+factor(country)+cluster(id),data=d,
 times=times,cause=1,max.clust=NULL)

 ### making group indidcator 
 mm <- model.matrix(~-1+factor(zyg),d)

 out1<-random.cif(add1,data=d,cause1=1,cause2=1,theta=1,same.cens=TRUE)
 summary(out1)

 out2<-random.cif(add1,data=d,cause1=1,cause2=1,theta=1,
		   theta.des=mm,same.cens=TRUE)
 summary(out2)

#########################################
##### 2 different causes
#########################################

 add2 <- timereg::comp.risk(Event(time,cause)~-1+factor(country)+cluster(id),data=d,
                  times=times,cause=2,max.clust=NULL)
 out3 <- random.cif(add1,data=d,cause1=1,cause2=2,cif2=add2,sym=1,same.cens=TRUE)
 summary(out3) ## negative dependence

 out4 <- random.cif(add1,data=d,cause1=1,cause2=2,cif2=add2,theta.des=mm,sym=1,same.cens=TRUE)
 summary(out4) ## negative dependence
}
}
\references{
A Semiparametric Random Effects Model for Multivariate Competing Risks Data,
Scheike, Zhang, Sun, Jensen (2010), Biometrika. 

Cross odds ratio Modelling of dependence for
Multivariate Competing Risks Data, Scheike and Sun (2012), work in progress.
}
\author{
Thomas Scheike
}
\keyword{survival}
