% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tetrachor.R
\name{tetrachoric}
\alias{or2prob}
\alias{tetrachoric}
\title{Estimate parameters from odds-ratio}
\usage{
tetrachoric(P, OR, approx = 0, ...)
}
\arguments{
\item{P}{Joint probabilities or marginals (if OR is given)}

\item{OR}{Odds-ratio}

\item{approx}{If TRUE an approximation of the tetrachoric correlation is used}

\item{...}{Additional arguments}
}
\description{
Calculate tetrachoric correlation of probabilities from odds-ratio
}
\examples{
tetrachoric(0.3,1.25) # Marginal p1=p2=0.3, OR=2
P <- matrix(c(0.1,0.2,0.2,0.5),2)
prod(diag(P))/prod(lava::revdiag(P))
##mets:::assoc(P)
tetrachoric(P)
or2prob(2,0.1)
or2prob(2,c(0.1,0.2))
}

