% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendly.R
\name{list_calendly_events}
\alias{list_calendly_events}
\title{Get Calendly Event Lists}
\usage{
list_calendly_events(token = NULL, user, count = 100)
}
\arguments{
\item{token}{You can provide the API key directly using this argument or this function will attempt to grab an API key that was stored using the `authorize("calendly")` function}

\item{user}{You need to retrieve the Calendly user's URI. You can do this by doing `user <- get_calendly_user()` and `user$resource$uri`}

\item{count}{The number of responses that should be returned. Default is 20 or you can say "all" to retrieve all.}
}
\value{
Calendly REST API response as a list
}
\description{
This is a function to get a list of scheduled events from a Calendly user.
}
\examples{
\dontrun{

authorize("calendly")
user <- get_calendly_user()
list_calendly_events(user = user$resource$uri)
}

}
