% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google-analytics.R
\name{get_ga_properties}
\alias{get_ga_properties}
\title{Get all property ids for all Google Analytics associated with an account id}
\usage{
get_ga_properties(account_id, token = NULL)
}
\arguments{
\item{account_id}{the account id of the properties you are trying to retrieve}

\item{token}{credentials for access to Google using OAuth.  `authorize("google")`}
}
\value{
All the property ids and information about them for a Google Analytics account.
}
\description{
This is a function to get the Google Analytics accounts that this user has access to
}
\examples{
\dontrun{

authorize("google")
accounts <- get_ga_user()

properties_list <- get_ga_properties(account_id = accounts$id[1])
}
}
