% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateComm.R
\name{simulateComm}
\alias{simulateComm}
\title{Generate a simulated community data matrix}
\usage{
simulateComm(tree, richness.vector, abundances)
}
\arguments{
\item{tree}{Phylo object}

\item{richness.vector}{Vector of desired species richness, one for each desired plot}

\item{abundances}{A vector of potential abundances, e.g. a log-normal distribution}
}
\value{
A community data matrix (a data frame) with species as columns and sites as
rows.
}
\description{
Given a phylo object, a vector of desired species richnesses, and a vector of potential
species abundances, will generate a community data matrix with these characteristics.
}
\details{
There is currently no implementation to control the frequency with which a
given species is selected.
}
\examples{
#simulate tree with birth-death process
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

sim.abundances <- round(rlnorm(5000, meanlog=2, sdlog=1)) + 1

cdm <- simulateComm(tree, richness.vector=10:25, abundances=sim.abundances)
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2015. Phylogenetic community
structure metrics and null models: a review with new methods and software.
bioRxiv 025726.
}

