% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_meteo_and_topo.R
\name{add_topo}
\alias{add_topo}
\title{Add topography data to meteo object}
\usage{
add_topo(meteo, topo, verbose = getOption("meteoland_verbosity", TRUE))
}
\arguments{
\item{meteo}{meteo object}

\item{topo}{topo object}

\item{verbose}{Logical indicating if the function must show messages and info.
Default value checks \code{"meteoland_verbosity"} option and if not set, defaults
to TRUE. It can be turned off for the function with FALSE, or session wide with
\code{options(meteoland_verbosity = FALSE)}}
}
\value{
meteo with the topography info added
}
\description{
Add topography data to meteo object
}
\details{
When using meteo data without topography info to create an interpolator,
topography must be added
}
\examples{
# example meteo
data(meteoland_meteo_no_topo_example)
# example topo
data(meteoland_topo_example)
# add topo
with_meteo(meteoland_meteo_no_topo_example) |>
  add_topo(meteoland_topo_example)

}
\seealso{
Other interpolator functions:
\code{\link{create_meteo_interpolator}()},
\code{\link{get_interpolation_params}()}, \code{\link{read_interpolator}()},
\code{\link{set_interpolation_params}()}, \code{\link{with_meteo}()},
\code{\link{write_interpolator}()}
}
