#Default parameters for weather generation


#' Default generation parameters
#'
#' @description
#' `r lifecycle::badge('deprecated')`
#'
#' Returns a list with the default parameterization for weather generation.
#'
#'
#' @return A list with the following items (default values in brackets):
#' \itemize{ \item\code{conditional [= "none"]}: A string to indicate whether
#' multi-year weather should be conditioned or not. If \code{conditional =
#' "arima"}, annual precipitation is conditioned on a stationary
#' auto-regressive model. If \code{conditional = "window"}, a moving-window is
#' used to subset the years used to parametrize the weather generation
#' algorithm for each target year (see parameter \code{range_size_years}). In
#' this last case, annual precipitation is conditioned to a log-normal variate
#' with parameters fitted from the selected years. \item\code{dry_wet_threshold
#' [= 0.3]}: Precipitation threshold (mm) for separating dry from wet days.
#' \item\code{wet_extreme_quantile_threshold [= 0.8]}: Quantile for separating
#' wet from extremely wet days. \item\code{range_size_days [= 5]}: Minimum half
#' range size to select the subset of dates with DOY similar to the currently
#' simulated. \item\code{range_size_years [= 12]}: Half range size to select
#' the subset of years in a moving-window around the current year (if
#' \code{conditional = "window"}). \item\code{n_knn_annual [= 100]}: Number of
#' years to be re-sampled using K-nearest neighbour for annual precipitation
#' (if \code{conditional = "arima"} or \code{conditional = "window"}).
#' \item\code{adjust_annual_precip [= TRUE]}: A logical flag to indicate that
#' annual precipitation generated by the algorithm should be adjusted to fit
#' either overall input annual precipitation or simulated annual precipitation.
#' \item\code{min_ratio [= 0.9]}: Minimum adjustment ratio for precipitation.
#' \item\code{max_ratio [= 1.2]}: Minimum adjustment ratio for precipitation. }
#' @author Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
#' @seealso \code{\link{weathergeneration}}
#' @references Apipattanavis, S., G. Podesta, B. Rajagopalan, and R. W. Katz
#' (2007), A semiparametric multivariate and multisite weather generator, Water
#' Resour. Res., 43, W11401, doi:10.1029/2006WR005714.
#'
#' Steinschneider S. & Brown C. (2013) A semiparametric multivariate, multisite
#' weather generator with low-frequency variability for use in climate risk
#' assessments. Water Resour. Res. 49, 7205-7220. doi:10.1002/wrcr.20528.
#' @export
defaultGenerationParams<-function() {
  # deprecation warning
  lifecycle::deprecate_stop(
    when = "2.0.0", what = "correctionpoints.errors()", with = NULL,
    details = "Current weather generation methods are currently deprecated because they operate with classes that are deprecated themselves, but for future versions, we plan to keep the functionality in new functions."
  )

  # return(list(
  #   conditional = "none",
  #   dry_wet_threshold = 0.3,
  #   wet_extreme_quantile_threshold = 0.8,
  #   n_knn_annual = 100,
  #   adjust_annual_precip = TRUE,
  #   range_size_days = 5,
  #   range_size_years = 12,
  #   min_ratio = 0.7,
  #   max_ratio = 1.3
  # ))
}
