# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

.temporalSmoothing <- function(input, numDays, prec) {
    .Call(`_meteoland_temporalSmoothing`, input, numDays, prec)
}

.slope <- function(data, nrows, ncols, cellWidth, cellHeight) {
    .Call(`_meteoland_slope`, data, nrows, ncols, cellWidth, cellHeight)
}

.aspect <- function(data, nrows, ncols, cellWidth, cellHeight) {
    .Call(`_meteoland_aspect`, data, nrows, ncols, cellWidth, cellHeight)
}

.dailyEquilibriumPET <- function(Temp, Rn) {
    .Call(`_meteoland_dailyEquilibriumPET`, Temp, Rn)
}

.penmanpoint <- function(latrad, elevation, slorad, asprad, J, Tmin, Tmax, RHmin, RHmax, R_s, u, z = 2.0, z0 = 0.001, alpha = 0.08, windfun = "1956") {
    .Call(`_meteoland_PenmanPETPointSeries`, latrad, elevation, slorad, asprad, J, Tmin, Tmax, RHmin, RHmax, R_s, u, z, z0, alpha, windfun)
}

.penmanmonteithpoint <- function(rc, elevation, Tmin, Tmax, RHmin, RHmax, Rn, u) {
    .Call(`_meteoland_PenmanMonteithPETPointSeries`, rc, elevation, Tmin, Tmax, RHmin, RHmax, Rn, u)
}

.PenmanPETPointsDay <- function(latrad, elevation, slorad, asprad, J, Tmin, Tmax, RHmin, RHmax, R_s, u, z = 2.0, z0 = 0.001, alpha = 0.08, windfun = "1956") {
    .Call(`_meteoland_PenmanPETPointsDay`, latrad, elevation, slorad, asprad, J, Tmin, Tmax, RHmin, RHmax, R_s, u, z, z0, alpha, windfun)
}

.interpolatePrecipitationSeriesPoints <- function(Xp, Yp, Zp, X, Y, Z, P, Psmooth, iniRp = 140000, alpha_event = 6.25, alpha_amount = 6.25, N_event = 20L, N_amount = 20L, iterations = 3L, popcrit = 0.5, fmax = 0.95) {
    .Call(`_meteoland_interpolatePrecipitationSeriesPoints`, Xp, Yp, Zp, X, Y, Z, P, Psmooth, iniRp, alpha_event, alpha_amount, N_event, N_amount, iterations, popcrit, fmax)
}

.interpolatePrecipitationEventSeriesPoints <- function(Xp, Yp, Zp, X, Y, Z, Pevent, iniRp = 140000, alpha = 6.25, N = 20L, iterations = 3L, popcrit = 0.5) {
    .Call(`_meteoland_interpolatePrecipitationEventSeriesPoints`, Xp, Yp, Zp, X, Y, Z, Pevent, iniRp, alpha, N, iterations, popcrit)
}

.pseudoRainfall <- function(RainM, daysMonthAll, shape = 2.0, scale = 4.0, firstMonth = 1L) {
    .Call(`_meteoland_pseudoRainfall`, RainM, daysMonthAll, shape, scale, firstMonth)
}

radiation_julianDay <- function(year, month, day) {
    .Call(`_meteoland_julianDay`, year, month, day)
}

radiation_dateStringToJulianDays <- function(dateStrings) {
    .Call(`_meteoland_dateStringToJulianDays`, dateStrings)
}

radiation_solarDeclination <- function(J) {
    .Call(`_meteoland_solarDeclination`, J)
}

radiation_solarConstant <- function(J) {
    .Call(`_meteoland_solarConstant`, J)
}

radiation_sunRiseSet <- function(latrad, slorad, asprad, delta) {
    .Call(`_meteoland_sunRiseSet`, latrad, slorad, asprad, delta)
}

radiation_solarElevation <- function(latrad, delta, hrad) {
    .Call(`_meteoland_solarElevation`, latrad, delta, hrad)
}

radiation_daylength <- function(latrad, slorad, asprad, delta) {
    .Call(`_meteoland_daylength`, latrad, slorad, asprad, delta)
}

radiation_daylengthseconds <- function(latrad, slorad, asprad, delta) {
    .Call(`_meteoland_daylengthseconds`, latrad, slorad, asprad, delta)
}

radiation_potentialRadiation <- function(solarConstant, latrad, slorad, asprad, delta) {
    .Call(`_meteoland_RpotDay`, solarConstant, latrad, slorad, asprad, delta)
}

radiation_solarRadiation <- function(solarConstant, latrad, elevation, slorad, asprad, delta, diffTemp, diffTempMonth, vpa, precipitation) {
    .Call(`_meteoland_RDay`, solarConstant, latrad, elevation, slorad, asprad, delta, diffTemp, diffTempMonth, vpa, precipitation)
}

radiation_directDiffuseInstant <- function(solarConstant, latrad, slorad, asprad, delta, hrad, R_p, R_s, clearday) {
    .Call(`_meteoland_directDiffuseInstant`, solarConstant, latrad, slorad, asprad, delta, hrad, R_p, R_s, clearday)
}

radiation_directDiffuseDay <- function(solarConstant, latrad, slorad, asprad, delta, R_s, clearday, nsteps = 24L) {
    .Call(`_meteoland_directDiffuseDay`, solarConstant, latrad, slorad, asprad, delta, R_s, clearday, nsteps)
}

radiation_skyLongwaveRadiation <- function(Tair, vpa, c = 0) {
    .Call(`_meteoland_skyLongwaveRadiation`, Tair, vpa, c)
}

radiation_outgoingLongwaveRadiation <- function(solarConstant, latrad, elevation, slorad, asprad, delta, vpa, tmin, tmax, R_s) {
    .Call(`_meteoland_outgoingLongwaveRadiation`, solarConstant, latrad, elevation, slorad, asprad, delta, vpa, tmin, tmax, R_s)
}

radiation_netRadiation <- function(solarConstant, latrad, elevation, slorad, asprad, delta, vpa, tmin, tmax, R_s, alpha = 0.08) {
    .Call(`_meteoland_netRadiation`, solarConstant, latrad, elevation, slorad, asprad, delta, vpa, tmin, tmax, R_s, alpha)
}

.potentialRadiationSeries <- function(latrad, slorad, asprad, J) {
    .Call(`_meteoland_potentialRadiationSeries`, latrad, slorad, asprad, J)
}

.potentialRadiationPoints <- function(latrad, slorad, asprad, J) {
    .Call(`_meteoland_potentialRadiationPoints`, latrad, slorad, asprad, J)
}

.radiationSeries <- function(latrad, elevation, slorad, asprad, J, diffTemp, diffTempMonth, VP, P) {
    .Call(`_meteoland_radiationSeries`, latrad, elevation, slorad, asprad, J, diffTemp, diffTempMonth, VP, P)
}

.radiationPoints <- function(latrad, elevation, slorad, asprad, J, diffTemp, diffTempMonth, VP, P) {
    .Call(`_meteoland_radiationPoints`, latrad, elevation, slorad, asprad, J, diffTemp, diffTempMonth, VP, P)
}

.meteo <- function(MeteoMonth, landscapeRainfall = as.numeric( c()), ERconv = 0.05, ERsyn = 0.2, shape = 2.0, scale = 4.0, albedo = 0.17, firstMonth = 1L, cyclic = FALSE) {
    .Call(`_meteoland_meteo`, MeteoMonth, landscapeRainfall, ERconv, ERsyn, shape, scale, albedo, firstMonth, cyclic)
}

.vapourPressureFromRH <- function(T, RH) {
    .Call(`_meteoland_vapourPressureFromRH`, T, RH)
}

.dewpointTemperatureFromRH <- function(T, RH) {
    .Call(`_meteoland_dewpointTemperatureFromRH`, T, RH)
}

.temp2SVP <- function(TD) {
    .Call(`_meteoland_temp2SVP`, TD)
}

.relativeHumidityFromMinMaxTemp <- function(Tmin, Tmax) {
    .Call(`_meteoland_relativeHumidityFromMinMaxTemp`, Tmin, Tmax)
}

.relativeHumidityFromDewpointTemp <- function(T, TD) {
    .Call(`_meteoland_relativeHumidityFromDewpointTemp`, T, TD)
}

.interpolateTdewSeriesPoints <- function(Xp, Yp, Zp, X, Y, Z, T, iniRp = 140000, alpha = 3.0, N = 30L, iterations = 3L) {
    .Call(`_meteoland_interpolateTdewSeriesPoints`, Xp, Yp, Zp, X, Y, Z, T, iniRp, alpha, N, iterations)
}

.interpolateTemperatureSeriesPoints <- function(Xp, Yp, Zp, X, Y, Z, T, iniRp = 140000, alpha = 3.0, N = 30L, iterations = 3L) {
    .Call(`_meteoland_interpolateTemperatureSeriesPoints`, Xp, Yp, Zp, X, Y, Z, T, iniRp, alpha, N, iterations)
}

utils_saturationVP <- function(temperature) {
    .Call(`_meteoland_saturationVapourPressure`, temperature)
}

utils_averageDailyVP <- function(Tmin, Tmax, RHmin, RHmax) {
    .Call(`_meteoland_averageDailyVapourPressure`, Tmin, Tmax, RHmin, RHmax)
}

utils_atmosphericPressure <- function(elevation) {
    .Call(`_meteoland_atmosphericPressure`, elevation)
}

utils_airDensity <- function(temperature, Patm) {
    .Call(`_meteoland_airDensity`, temperature, Patm)
}

utils_averageDaylightTemperature <- function(Tmin, Tmax) {
    .Call(`_meteoland_averageDaylightTemperature`, Tmin, Tmax)
}

utils_latentHeatVaporisation <- function(temperature) {
    .Call(`_meteoland_latentHeatVaporisation`, temperature)
}

utils_latentHeatVaporisationMol <- function(temperature) {
    .Call(`_meteoland_latentHeatVaporisationMol`, temperature)
}

utils_psychrometricConstant <- function(temperature, Patm) {
    .Call(`_meteoland_psychrometricConstant`, temperature, Patm)
}

utils_saturationVaporPressureCurveSlope <- function(temperature) {
    .Call(`_meteoland_saturationVaporPressureCurveSlope`, temperature)
}

penman <- function(latrad, elevation, slorad, asprad, J, Tmin, Tmax, RHmin, RHmax, R_s, u, z = 2.0, z0 = 0.001, alpha = 0.08, windfun = "1956") {
    .Call(`_meteoland_PenmanPET`, latrad, elevation, slorad, asprad, J, Tmin, Tmax, RHmin, RHmax, R_s, u, z, z0, alpha, windfun)
}

penmanmonteith <- function(rc, elevation, Tmin, Tmax, RHmin, RHmax, Rn, u = NA_real_) {
    .Call(`_meteoland_PenmanMonteithPET`, rc, elevation, Tmin, Tmax, RHmin, RHmax, Rn, u)
}

.getWindFieldIndexAndFactor <- function(windSpeed, windDirection, wfSpeed, wfDirection) {
    .Call(`_meteoland_getWindFieldIndexAndFactor`, windSpeed, windDirection, wfSpeed, wfDirection)
}

.interpolateWindFieldSeriesPoints <- function(Xp, Yp, WS, WD, X, Y, I, F, iniRp = 140000, alpha = 3.0, N = 30L, iterations = 3L) {
    .Call(`_meteoland_interpolateWindFieldSeriesPoints`, Xp, Yp, WS, WD, X, Y, I, F, iniRp, alpha, N, iterations)
}

.interpolateWindStationSeriesPoints <- function(Xp, Yp, WS, WD, X, Y, iniRp = 140000, alpha = 3.0, N = 30L, iterations = 3L) {
    .Call(`_meteoland_interpolateWindStationSeriesPoints`, Xp, Yp, WS, WD, X, Y, iniRp, alpha, N, iterations)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('_meteoland_RcppExport_registerCCallable', PACKAGE = 'meteoland')
})
