% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.R
\name{meta_name}
\alias{meta_name}
\title{Create name/content metadata tag pairs}
\usage{
meta_name(.meta = meta(), ...)
}
\arguments{
\item{.meta}{A \code{meta} object created by \code{\link[=meta]{meta()}} or \code{\link[=as_meta]{as_meta()}}, or returned
by a \verb{meta_*()} object.}

\item{...}{Name (argument names) and content (argument value) pairs.}
}
\value{
A \code{meta} object, or a set of \verb{<meta>} HTML tags inside an HTML
\verb{<head>} tag. For use in \code{\link[rmarkdown:html_document]{rmarkdown::html_document()}}, \code{\link[shiny:runApp]{shiny::runApp()}},
or other HTML locations.
}
\description{
Creates metadata tag pairs where the arguments are the name values and their
values are content values.
}
\examples{
meta() \%>\%
  meta_name("github-repo" = "hadley/r4ds")

}
\seealso{
Other meta: 
\code{\link{meta_apple_itunes_app}()},
\code{\link{meta_apple_web_app}()},
\code{\link{meta_general}()},
\code{\link{meta_geo}()},
\code{\link{meta_social}()},
\code{\link{meta_tag}()},
\code{\link{meta_viewport}()},
\code{\link{meta}()}
}
\concept{meta}
