% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaplot.R
\name{metapanel}
\alias{metapanel}
\title{Panel Function for Metaplot Scatterplot}
\usage{
metapanel(x, y, groups = NULL, xref = NULL, yref = NULL,
  ysmooth = FALSE, xsmooth = FALSE, density = FALSE, iso = FALSE,
  fit = conf, conf = FALSE, loc = 0, msg = "metastats", ...)
}
\arguments{
\item{x}{x values}

\item{y}{y values}

\item{groups}{optional grouping item}

\item{xref}{reference line from x axis}

\item{yref}{reference line from y axis}

\item{ysmooth}{supply loess smooth of y on x}

\item{xsmooth}{supply loess smmoth of x on y}

\item{density}{plot point density instead of points}

\item{iso}{use isometric axes with line of unity}

\item{fit}{draw a linear fit of y ~ x}

\item{conf}{logical, or width for a confidence region around a linear fit; passed to \code{\link{region}}; \code{TRUE} defaults to 95 percent confidence interval}

\item{loc}{where to print statistics on a panel}

\item{msg}{a function to print text on a panel: called with x values, y values, and \dots.}

\item{...}{passed to panel.superpose, panel.smoothScatter, panel.xyplot, panel.polygon, region, panel.text}
}
\description{
Panel function for metaplot::scatterplot.data.frame.
}
\seealso{
\code{\link{metastats}}

\code{\link{scatter.data.frame}}

Other panel functions: \code{\link{l.p}},
  \code{\link{my.diag.panel}}, \code{\link{u.p}}

Other metaplots: \code{\link{metaplot}}
}
