% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valmeta.r
\name{acplot.valmeta}
\alias{acplot.valmeta}
\title{Plot the autocorrelation of a Bayesian meta-analysis model}
\usage{
acplot.valmeta(x, ...)
}
\arguments{
\item{x}{An object of class \code{"valmeta"}}

\item{\ldots}{Additional arguments which are currently not used}
}
\value{
An object of class \code{ggplot}
}
\description{
Function to display autocorrelation of a fitted Bayesian meta-analysis model.
}
\details{
Results are displayed for the estimated mean (\code{mu}) and standard-deviation (\code{tau}) of the meta-analysis model.
}
\examples{
\dontrun{
data(EuroSCORE)

fit <- valmeta(cstat=c.index, cstat.se=se.c.index, cstat.cilb=c.index.95CIl,
               cstat.ciub=c.index.95CIu, N=n, O=n.events, 
               data=EuroSCORE, method="BAYES", slab=Study)
acplot(fit)
} 

}
\author{
Thomas Debray <thomas.debray@gmail.com>
}
\keyword{autocorrelation}
\keyword{convergence}
\keyword{meta-analysis}
