% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old_taxa--taxon_database.R
\name{taxon_database}
\alias{taxon_database}
\title{Taxonomy database class}
\usage{
taxon_database(name = NULL, url = NULL, description = NULL, id_regex = NULL)
}
\arguments{
\item{name}{(character) name of the database}

\item{url}{(character) url for the database}

\item{description}{(character) description of the database}

\item{id_regex}{(character) id regex}
}
\value{
An `R6Class` object of class `TaxonDatabase`
}
\description{
Used to store information about taxonomy databases. This is typically used to
store where taxon information came from in [taxon()] objects.
}
\examples{
# create a database entry
(x <- taxon_database(
  "ncbi",
  "http://www.ncbi.nlm.nih.gov/taxonomy",
  "NCBI Taxonomy Database",
  "*"
))
x$name
x$url

# use pre-created database objects
database_list
database_list$ncbi
}
\seealso{
[database_list]

Other classes: 
\code{\link{hierarchies}()},
\code{\link{hierarchy}()},
\code{\link{taxa}()},
\code{\link{taxmap}()},
\code{\link{taxon_id}()},
\code{\link{taxon_name}()},
\code{\link{taxon_rank}()},
\code{\link{taxonomy}()},
\code{\link{taxon}()}
}
\concept{classes}
