% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers.R
\name{parse_dada2}
\alias{parse_dada2}
\title{Convert the output of dada2 to a taxmap object}
\usage{
parse_dada2(
  seq_table,
  tax_table,
  class_key = "taxon_name",
  class_regex = "(.*)",
  include_match = TRUE
)
}
\arguments{
\item{seq_table}{The ASV abundance matrix, with rows as samples and columns as ASV ids or
sequences}

\item{tax_table}{The table with taxonomic classifications for ASVs, with ASVs in rows and
taxonomic ranks as columns.}

\item{class_key}{(\code{character} of length 1) The identity of the capturing groups defined using
\code{class_regex}. The length of \code{class_key} must be equal to the number of capturing groups
specified in \code{class_regex}. Any names added to the terms will be used as column names in the
output. At least one \code{"taxon_name"} must be specified. Only \code{"info"} can be used multiple
times. Each term must be one of those described below: * \code{taxon_name}: The name of a taxon. Not
necessarily unique, but are interpretable by a particular \code{database}. Requires an internet
connection. * \code{taxon_rank}: The rank of the taxon. This will be used to add rank info into the
output object that can be accessed by \code{out$taxon_ranks()}. * \code{info}: Arbitrary taxon info you
want included in the output. Can be used more than once.}

\item{class_regex}{(\code{character} of length 1) A regular expression with capturing groups
indicating the locations of data for each taxon in the \code{class} term in the \code{key} argument. The
identity of the information must be specified using the \code{class_key} argument. The \code{class_sep}
option can be used to split the classification into data for each taxon before matching. If
\code{class_sep} is \code{NULL}, each match of \code{class_regex} defines a taxon in the classification.}

\item{include_match}{(\code{logical} of length 1) If \code{TRUE}, include the part of the input matched by
\code{class_regex} in the output object.}
}
\value{
\code{\link{taxmap}}
}
\description{
Convert the ASV table and taxonomy table returned by dada2 into a taxmap object. An example of
the input format can be found by following the dada2 tutorial here:
shttps://benjjneb.github.io/dada2/tutorial.html
}
\seealso{
Other parsers: 
\code{\link{parse_edge_list}()},
\code{\link{parse_greengenes}()},
\code{\link{parse_mothur_tax_summary}()},
\code{\link{parse_mothur_taxonomy}()},
\code{\link{parse_newick}()},
\code{\link{parse_phyloseq}()},
\code{\link{parse_phylo}()},
\code{\link{parse_qiime_biom}()},
\code{\link{parse_rdp}()},
\code{\link{parse_silva_fasta}()},
\code{\link{parse_ubiome}()},
\code{\link{parse_unite_general}()}
}
\concept{parsers}
