% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers.R
\name{parse_newick}
\alias{parse_newick}
\title{Parse a Newick file}
\usage{
parse_newick(file = NULL, text = NULL)
}
\arguments{
\item{file}{(\code{character} of length 1) The file path to the input file. Either \code{file} or \code{text} must be supplied but not both.}

\item{text}{(\code{character} of length 1) The raw text to parse. Either \code{file} or \code{text} must be supplied but not both.}
}
\value{
\code{\link{taxmap}}
}
\description{
Parse a Newick file into a taxmap object.
}
\details{
The input file has a format like:

\preformatted{
(ant:17, (bat:31, cow:22):7, dog:22, (elk:33, fox:12):40);
(dog:20, (elephant:30, horse:60):20):50;
}
}
\seealso{
Other parsers: \code{\link{parse_greengenes}},
  \code{\link{parse_mothur_tax_summary}},
  \code{\link{parse_mothur_taxonomy}},
  \code{\link{parse_phyloseq}}, \code{\link{parse_phylo}},
  \code{\link{parse_qiime_biom}}, \code{\link{parse_rdp}},
  \code{\link{parse_silva_fasta}},
  \code{\link{parse_unite_general}}
}
