% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_ANOVA_med_range_quart.R
\name{es_from_med_min_max}
\alias{es_from_med_min_max}
\title{Convert median, quartiles, and range of two independent groups into several effect size measures}
\usage{
es_from_med_min_max(
  min_exp,
  med_exp,
  max_exp,
  n_exp,
  min_nexp,
  med_nexp,
  max_nexp,
  n_nexp,
  smd_to_cor = "viechtbauer",
  reverse_med
)
}
\arguments{
\item{min_exp}{minimum value of the experimental/exposed group.}

\item{med_exp}{median value of the experimental/exposed group.}

\item{max_exp}{maximum value of the experimental/exposed group.}

\item{n_exp}{number of participants in the experimental/exposed group.}

\item{min_nexp}{minimum value of the non-experimental/non-exposed group.}

\item{med_nexp}{median value of the non-experimental/non-exposed group.}

\item{max_nexp}{maximum value of the non-experimental/non-exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{smd_to_cor}{formula used to convert the generated \code{cohen_d} value into a coefficient correlation (see details).}

\item{reverse_med}{a logical value indicating whether the direction of generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab \cr
\tab \cr
\code{converted effect size measure} \tab MD + D + G\cr
\tab OR + R + Z \cr
\code{required input data} \tab See 'Section 12. Median, range and/or interquartile range'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}

This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab \cr
\tab \cr
\code{converted effect size measure} \tab MD + D + G\cr
\tab OR + R + Z \cr
\code{required input data} \tab See 'Section 12. Median, range and/or interquartile range'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert median, quartiles, and range of two independent groups into several effect size measures
}
\details{
This function first converts a Cohen's d (D), Hedges' g (G)
and mean difference (MD) from the medians and ranges of two independent groups.
Odds ratio (OR) and correlation coefficients (R/Z) are then converted from the Cohen's d.

\strong{This function recreates means+SD of the two groups}  (Wan et al., 2014):
\deqn{mean\_exp = \frac{min\_exp + 2*med\_exp + max\_exp}{4}}
\deqn{mean\_nexp = \frac{min\_nexp + 2*med\_nexp + max\_nexp}{4}}
\deqn{mean\_sd\_exp = \frac{max\_exp - min\_exp}{2*qnorm((n\_exp-0.375) / (n\_exp+0.25))}}
\deqn{mean\_sd\_nexp = \frac{max\_nexp - min\_nexp}{2*qnorm((n\_nexp-0.375) / (n\_nexp+0.25))}}

Note that if the group sample size is inferior to 50, a correction is applied to estimate the standard deviation.

\strong{From these means+SD, the function computes MD, D and G} using formulas
described in \code{\link{es_from_means_sd}()}.

\strong{To estimate other effect size measures},
calculations of the \code{\link{es_from_cohen_d}()} are applied.

\strong{Importantly,}, authors of the Cochrane Handbook stated
"As a general rule, we recommend that ranges should not be used
to estimate SDs." (see section 6.5.2.6).
It is thus a good practice to explore the consequences of
the use of this conversion in sensitivity analyses.
}
\examples{
es_from_med_min_max(
  min_exp = 1335, med_exp = 1400,
  max_nexp = 1765, n_exp = 40,
  min_nexp = 1481, med_nexp = 1625,
  max_exp = 1800, n_nexp = 40
)
}
\references{
Wan, X., Wang, W., Liu, J. et al. Estimating the sample mean and standard deviation from the sample size, median, range and/or interquartile range. BMC Med Res Methodol 14, 135 (2014). https://doi.org/10.1186/1471-2288-14-135

Higgins JPT, Li T, Deeks JJ (editors). Chapter 6: Choosing effect size measures and computing estimates of effect. In: Higgins JPT, Thomas J, Chandler J, Cumpston M, Li T, Page MJ, Welch VA (editors). Cochrane Handbook for Systematic Reviews of Interventions version 6.3 (updated February 2022). Cochrane, 2022. Available from www.training.cochrane.org/handbook.
}
