% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metacor.R
\name{metacor}
\alias{metacor}
\title{Meta-analysis of correlations}
\usage{
metacor(
  cor,
  n,
  studlab,
  data = NULL,
  subset = NULL,
  exclude = NULL,
  cluster = NULL,
  sm = gs("smcor"),
  level = gs("level"),
  common = gs("common"),
  random = gs("random") | !is.null(tau.preset),
  overall = common | random,
  overall.hetstat = common | random,
  prediction = gs("prediction") | !missing(method.predict),
  method.tau = gs("method.tau"),
  method.tau.ci = gs("method.tau.ci"),
  tau.preset = NULL,
  TE.tau = NULL,
  tau.common = gs("tau.common"),
  level.ma = gs("level.ma"),
  method.random.ci = gs("method.random.ci"),
  adhoc.hakn.ci = gs("adhoc.hakn.ci"),
  level.predict = gs("level.predict"),
  method.predict = gs("method.predict"),
  adhoc.hakn.pi = gs("adhoc.hakn.pi"),
  null.effect = 0,
  method.bias = gs("method.bias"),
  backtransf = gs("backtransf"),
  text.common = gs("text.common"),
  text.random = gs("text.random"),
  text.predict = gs("text.predict"),
  text.w.common = gs("text.w.common"),
  text.w.random = gs("text.w.random"),
  title = gs("title"),
  complab = gs("complab"),
  outclab = "",
  subgroup,
  subgroup.name = NULL,
  print.subgroup.name = gs("print.subgroup.name"),
  sep.subgroup = gs("sep.subgroup"),
  test.subgroup = gs("test.subgroup"),
  prediction.subgroup = gs("prediction.subgroup"),
  byvar,
  adhoc.hakn,
  keepdata = gs("keepdata"),
  warn.deprecated = gs("warn.deprecated"),
  control = NULL,
  ...
)
}
\arguments{
\item{cor}{Correlation.}

\item{n}{Number of observations.}

\item{studlab}{An optional vector with study labels.}

\item{data}{An optional data frame containing the study
information, i.e., cor and n.}

\item{subset}{An optional vector specifying a subset of studies to
be used.}

\item{exclude}{An optional vector specifying studies to exclude
from meta-analysis, however, to include in printouts and forest
plots.}

\item{cluster}{An optional vector specifying which estimates come
from the same cluster resulting in the use of a three-level
meta-analysis model.}

\item{sm}{A character string indicating which summary measure
(\code{"ZCOR"} or \code{"COR"}) is to be used for pooling of
studies.}

\item{level}{The level used to calculate confidence intervals for
individual studies.}

\item{common}{A logical indicating whether a common effect
meta-analysis should be conducted.}

\item{random}{A logical indicating whether a random effects
meta-analysis should be conducted.}

\item{overall}{A logical indicating whether overall summaries
should be reported. This argument is useful in a meta-analysis
with subgroups if overall results should not be reported.}

\item{overall.hetstat}{A logical value indicating whether to print
heterogeneity measures for overall treatment comparisons. This
argument is useful in a meta-analysis with subgroups if
heterogeneity statistics should only be printed on subgroup
level.}

\item{prediction}{A logical indicating whether a prediction
interval should be printed.}

\item{method.tau}{A character string indicating which method is
used to estimate the between-study variance \eqn{\tau^2} and its
square root \eqn{\tau} (see \code{\link{meta-package}}).}

\item{method.tau.ci}{A character string indicating which method is
used to estimate the confidence interval of \eqn{\tau^2} and
\eqn{\tau} (see \code{\link{meta-package}}).}

\item{tau.preset}{Prespecified value for the square root of the
between-study variance \eqn{\tau^2}.}

\item{TE.tau}{Overall treatment effect used to estimate the
between-study variance tau-squared.}

\item{tau.common}{A logical indicating whether tau-squared should
be the same across subgroups.}

\item{level.ma}{The level used to calculate confidence intervals
for meta-analysis estimates.}

\item{method.random.ci}{A character string indicating which method
is used to calculate confidence interval and test statistic for
random effects estimate (see \code{\link{meta-package}}).}

\item{adhoc.hakn.ci}{A character string indicating whether an
\emph{ad hoc} variance correction should be applied in the case
of an arbitrarily small Hartung-Knapp variance estimate (see
\code{\link{meta-package}}).}

\item{level.predict}{The level used to calculate prediction
interval for a new study.}

\item{method.predict}{A character string indicating which method is
used to calculate a prediction interval (see
\code{\link{meta-package}}).}

\item{adhoc.hakn.pi}{A character string indicating whether an
\emph{ad hoc} variance correction should be applied for
prediction interval (see \code{\link{meta-package}}).}

\item{null.effect}{A numeric value specifying the effect under the
null hypothesis.}

\item{method.bias}{A character string indicating which test is to
be used. Either \code{"Begg"}, \code{"Egger"}, or
\code{"Thompson"}, can be abbreviated. See function
\code{\link{metabias}}.}

\item{backtransf}{A logical indicating whether results for Fisher's
z transformed correlations (\code{sm = "ZCOR"}) should be back
transformed in printouts and plots. If TRUE (default), results
will be presented as correlations; otherwise Fisher's z
transformed correlations will be shown.}

\item{text.common}{A character string used in printouts and forest
plot to label the pooled common effect estimate.}

\item{text.random}{A character string used in printouts and forest
plot to label the pooled random effects estimate.}

\item{text.predict}{A character string used in printouts and forest
plot to label the prediction interval.}

\item{text.w.common}{A character string used to label weights of
common effect model.}

\item{text.w.random}{A character string used to label weights of
random effects model.}

\item{title}{Title of meta-analysis / systematic review.}

\item{complab}{Comparison label.}

\item{outclab}{Outcome label.}

\item{subgroup}{An optional vector to conduct a meta-analysis with
subgroups.}

\item{subgroup.name}{A character string with a name for the
subgroup variable.}

\item{print.subgroup.name}{A logical indicating whether the name of
the subgroup variable should be printed in front of the group
labels.}

\item{sep.subgroup}{A character string defining the separator
between name of subgroup variable and subgroup label.}

\item{test.subgroup}{A logical value indicating whether to print
results of test for subgroup differences.}

\item{prediction.subgroup}{A logical indicating whether prediction
intervals should be printed for subgroups.}

\item{byvar}{Deprecated argument (replaced by 'subgroup').}

\item{adhoc.hakn}{Deprecated argument (replaced by 'adhoc.hakn.ci').}

\item{keepdata}{A logical indicating whether original data (set)
should be kept in meta object.}

\item{warn.deprecated}{A logical indicating whether warnings should
be printed if deprecated arguments are used.}

\item{control}{An optional list to control the iterative process to
estimate the between-study variance \eqn{\tau^2}. This argument
is passed on to \code{\link[metafor]{rma.uni}}.}

\item{\dots}{Additional arguments (to catch deprecated arguments).}
}
\value{
An object of class \code{c("metacor", "meta")} with corresponding
generic functions (see \code{\link{meta-object}}).
}
\description{
Calculation of common effect and random effects estimates for
meta-analyses with correlations; inverse variance weighting is used
for pooling.
}
\details{
Common effect and random effects meta-analysis of correlations based
either on Fisher's z transformation of correlations (\code{sm =
"ZCOR"}) or direct combination of (untransformed) correlations
(\code{sm = "COR"}) (see Cooper et al., p264-5 and p273-4). Only
few statisticians would advocate the use of untransformed
correlations unless sample sizes are very large (see Cooper et al.,
p265). The artificial example given below shows that the smallest
study gets the largest weight if correlations are combined directly
because the correlation is closest to 1.

A three-level random effects meta-analysis model (Van den Noortgate
et al., 2013) is utilized if argument \code{cluster} is used and at
least one cluster provides more than one estimate. Internally,
\code{\link[metafor]{rma.mv}} is called to conduct the analysis and
\code{\link[metafor]{weights.rma.mv}} with argument \code{type =
"rowsum"} is used to calculate random effects weights.

Default settings are utilised for several arguments (assignments
using \code{\link{gs}} function). These defaults can be changed for
the current R session using the \code{\link{settings.meta}}
function.

Furthermore, R function \code{\link{update.meta}} can be used to
rerun a meta-analysis with different settings.

\subsection{Subgroup analysis}{

Argument \code{subgroup} can be used to conduct subgroup analysis for
a categorical covariate. The \code{\link{metareg}} function can be
used instead for more than one categorical covariate or continuous
covariates.
}

\subsection{Exclusion of studies from meta-analysis}{

Arguments \code{subset} and \code{exclude} can be used to exclude
studies from the meta-analysis. Studies are removed completely from
the meta-analysis using argument \code{subset}, while excluded
studies are shown in printouts and forest plots using argument
\code{exclude} (see Examples in \code{\link{metagen}}).
Meta-analysis results are the same for both arguments.
}

\subsection{Presentation of meta-analysis results}{

Internally, both common effect and random effects models are
calculated regardless of values choosen for arguments
\code{common} and \code{random}. Accordingly, the estimate
for the random effects model can be extracted from component
\code{TE.random} of an object of class \code{"meta"} even if
argument \code{random = FALSE}. However, all functions in R
package \bold{meta} will adequately consider the values for
\code{common} and \code{random}. E.g. functions
\code{\link{print.meta}} and \code{\link{forest.meta}} will not
print results for the random effects model if \code{random =
FALSE}.

A prediction interval will only be shown if \code{prediction =
TRUE}.
}
}
\note{
The function \code{\link{metagen}} is called internally to
calculate individual and overall treatment estimates and standard
errors.
}
\examples{
m1 <- metacor(c(0.85, 0.7, 0.95), c(20, 40, 10))

# Print correlations (back transformed from Fisher's z
# transformation)
#
m1

# Print Fisher's z transformed correlations 
#
print(m1, backtransf = FALSE)

# Forest plot with back transformed correlations
#
forest(m1)

# Forest plot with Fisher's z transformed correlations
#
forest(m1, backtransf = FALSE)

m2 <- update(m1, sm = "cor")
m2

\dontrun{
# Identical forest plots (as back transformation is the identity
# transformation)
forest(m2)
forest(m2, backtransf = FALSE)
}

}
\references{
Cooper H, Hedges LV, Valentine JC (2009):
\emph{The Handbook of Research Synthesis and Meta-Analysis},
2nd Edition.
New York: Russell Sage Foundation

Van den Noortgate W, López-López JA, Marín-Martínez F, Sánchez-Meca J (2013):
Three-level meta-analysis of dependent effect sizes.
\emph{Behavior Research Methods},
\bold{45}, 576--94
}
\seealso{
\code{\link{meta-package}}, \code{\link{update.meta}},
  \code{\link{metacont}}, \code{\link{metagen}},
  \code{\link{print.meta}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
