% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaveFlux.R
\name{WaveFlux}
\alias{WaveFlux}
\title{Calculate wave-activity flux}
\usage{
WaveFlux(gh, u, v, lon, lat, lev, g = 9.81, a = 6371000)
}
\arguments{
\item{gh}{geopotential height}

\item{u}{mean zonal velocity}

\item{v}{mean meridional velocity}

\item{lon}{longitude (in degrees)}

\item{lat}{latitude (in degrees)}

\item{lev}{pressure level (in hPa)}

\item{g}{acceleration of gravity}

\item{a}{Earth's radius}
}
\value{
A list with elements: longitude, latitude, and the two horizontal components
of the wave activity flux.
}
\description{
Calculate wave-activity flux
}
\details{
Calculates Plum-like wave activity fluxes
}
\references{
Takaya, K. and H. Nakamura, 2001: A Formulation of a Phase-Independent Wave-Activity Flux for Stationary and Migratory Quasigeostrophic Eddies on a Zonally Varying Basic Flow. J. Atmos. Sci., 58, 608–627, \url{https://journals.ametsoc.org/doi/abs/10.1175/1520-0469(2001)058\%3C0608\%3AAFOAPI\%3E2.0.CO\%3B2} \cr
Adapted from \url{https://github.com/marisolosman/Reunion_Clima/blob/master/WAF/Calculo_WAF.ipynb}
}
\seealso{
Other meteorology functions: 
\code{\link{Derivate}()},
\code{\link{EOF}()},
\code{\link{GeostrophicWind}()},
\code{\link{thermodynamics}},
\code{\link{waves}}
}
\concept{meteorology functions}
