% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lru.R
\name{permanent_cache}
\alias{permanent_cache}
\alias{lru_cache}
\title{`basic_cache` makes a cache that does not expire old entries.
It should be used in situations where you know the number of
things to remember is bounded.}
\usage{
permanent_cache()

lru_cache(size = 10000)
}
\arguments{
\item{size}{The maximum number of results to keep.}
}
\value{
A function f(key, value) which takes a string in the first
parameter and a lazily evaluated value in the second. `f`
will use the string key to retrieve a value from the cache, or
return the matching item from the cache, or force the second
argument and return that, remembering the result on future calls.

When the number of entries in the cache exceeds \code{size}, the least
recently accessed entries are removed.
}
\description{
`basic_cache` makes a cache that does not expire old entries.
It should be used in situations where you know the number of
things to remember is bounded.

Construct a cache with least-recently-used policy.
}
