% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roc.analysis.R
\name{roc.analysis}
\alias{roc.analysis}
\title{ROC analysis to find optimum parameter value}
\usage{
roc.analysis(i.data, i.param.values = seq(1.5, 4.5, 0.1), i.graph = F,
  i.graph.file = F, i.graph.file.name = "", i.graph.title = "",
  i.graph.subtitle = "", i.output = ".", ...)
}
\arguments{
\item{i.data}{Data frame of input data.}

\item{i.param.values}{range of i.param values to test.}

\item{i.graph}{create a graph with the outputs (T/F).}

\item{i.graph.file}{write the graph to a file.}

\item{i.graph.file.name}{name of the output file.}

\item{i.graph.title}{title of the graph.}

\item{i.graph.subtitle}{subtitle of the graph.}

\item{i.output}{output directory.}

\item{...}{other paramaters to be used by memgoodness function.}
}
\value{
\code{roc.analysis} returns a list.
An object of class \code{mem} is a list containing at least the following components:
  \item{optimum}{optimum value.}
  \item{results}{Detailed results of each iteration.}
}
\description{
Function \code{roc.analysis} perform a ROC analysis
}
\details{
To be written
}
\examples{
# Castilla y Leon Influenza Rates data
data(flucyl)
# ROC analysis
epi.roc<-roc.analysis(flucyl,i.param.values=seq(2.6,2.8,0.1),i.detection.values=seq(2.6,2.8,0.1))
epi.roc$results

}
\references{
Vega Alonso, Tomas, Jose E Lozano Alonso, Raul Ortiz de Lejarazu, and Marisol Gutierrez Perez. 2004.
Modelling Influenza Epidemic: Can We Detect the Beginning and Predict the Intensity and Duration?
International Congress Series, Options for the Control of Influenza V. Proceedings of the International
Conference on Options for the Control of Influenza V, 1263 (June): 281-83. doi:10.1016/j.ics.2004.02.121.\cr
Vega, Tomas, Jose Eugenio Lozano, Tamara Meerhoff, Rene Snacken, Joshua Mott, Raul Ortiz de Lejarazu, and
Baltazar Nunes. 2013. Influenza Surveillance in Europe: Establishing Epidemic Thresholds by the Moving
Epidemic Method. Influenza and Other Respiratory Viruses 7 (4): 546-58. doi:10.1111/j.1750-2659.2012.00422.x.\cr
Vega, Tomas, Jose E. Lozano, Tamara Meerhoff, Rene Snacken, Julien Beaute, Pernille Jorgensen, Raul Ortiz
de Lejarazu, et al. 2015. Influenza Surveillance in Europe: Comparing Intensity Levels Calculated Using
the Moving Epidemic Method. Influenza and Other Respiratory Viruses 9 (5): 234-46. doi:10.1111/irv.12330.
}
\author{
Jose E. Lozano \email{lozalojo@gmail.com}
}
\keyword{influenza}
