% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/el_pairwise.R
\name{el_pairwise}
\alias{el_pairwise}
\title{Empirical likelihood pairwise comparisons}
\usage{
el_pairwise(
  formula,
  data,
  control = NULL,
  k = 1,
  alpha = 0.05,
  method = c("AMC", "NB"),
  B,
  nthread = 1,
  progress = TRUE,
  maxit = 10000,
  abstol = 1e-08
)
}
\arguments{
\item{formula}{A formula object. It must specify variables for response, treatment, and block as 'response ~ treatment | block'. Note that the use of vertical bar (|) separating treatment and block.}

\item{data}{A data frame containing the variables in the formula.}

\item{control}{Optional character specifying the treatment for comparisons with control.}

\item{k}{Single integer for \eqn{k} in \eqn{k}-FWER. Defaults to 1.}

\item{alpha}{Level of the test. Defaults to 0.05.}

\item{method}{Single character for the procedure to be used; either 'AMC' or 'NB' is supported. Defaults to 'AMC'.}

\item{B}{Number of Monte Carlo samples for the AMC (number of bootstrap replicates for the NB).}

\item{nthread}{Number of threads to be used with OpenMP. Only applied when the NB is chosen as the method. Defaults to 1.}

\item{progress}{If TRUE, will show progress status.}

\item{maxit}{Maximum number of iterations for optimization. Defaults to 10000.}

\item{abstol}{Absolute convergence tolerance for optimization. Defaults to 1e-08.}
}
\value{
A list with class \code{c("pairwise", "melt")}.
}
\description{
Tests all pairwise comparisons or comparisons with control for general block designs. Two single step asymptotic \eqn{k}-FWER (generalized family-wise error rate) controlling procedures are available: asymptotic Monte Carlo (AMC) and nonparametric bootstrap (NB).
}
\examples{
## all pairwise comparisons
el_pairwise(clo ~ trt | blk, clothianidin, B = 10000)

## comparisons with control
el_pairwise(clo ~ trt | blk, clothianidin, control = "Naked", method = "NB", B = 1000)

}
\references{
Kim, E., MacEachern, S., and Peruggia, M., (2021),
"Empirical Likelihood for the Analysis of Experimental Designs,"
\href{https://arxiv.org/abs/2112.09206}{arxiv:2112.09206}.
}
