% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pccc_conditions.R
\name{get_pccc_conditions}
\alias{get_pccc_conditions}
\title{Pediatric Complex Chronic Condition and Subconditions}
\usage{
get_pccc_conditions()
}
\value{
a \code{data.frame} with the following columns
\itemize{
\item \code{condition}: (character) syntax valid name for the condition
\item \code{subconditions}: (character) syntax valid name for the subcondition
\item \code{conditions_label.}: (character) human readable label for the condition
\item \code{subconditions_label}: (character) human readable label for the
subcondition
}
}
\description{
Retrieve a copy of internal lookup tables for the syntax valid and human
readable labels of the Pediatric Complex Chronic Conditions (PCCC) conditions
and subconditions.
}
\examples{
get_pccc_conditions()

}
\seealso{
\itemize{
\item \code{\link[=get_pccc_codes]{get_pccc_codes()}} for the lookup table of ICD codes used for the PCCC.
\item \code{\link[=comorbidities]{comorbidities()}} for applying comorbidity algorithms to a data set.
}
}
