\encoding{UTF-8}
\name{Vertical profiles}
\alias{vprofile_leafAreaDensity}
\alias{vprofile_rootDistribution}
\alias{vprofile_fuelBulkDensity}
\alias{vprofile_PARExtinction}
\alias{vprofile_SWRExtinction}
\alias{vprofile_windExtinction}
\title{
Vertical profiles
}
\description{
Functions to generate vertical profiles generated by an input \code{\link{forest}} object.
}
\usage{
vprofile_leafAreaDensity(x, SpParams = NULL, z = NULL, gdd = NA, 
                         byCohorts = FALSE, bySpecies = FALSE, draw = TRUE, 
                         xlim = NULL)
vprofile_rootDistribution(x, SpParams, d = NULL,  bySpecies = FALSE, draw = TRUE, 
                          xlim = NULL)
vprofile_fuelBulkDensity(x, SpParams, z = NULL, gdd = NA, draw = TRUE, 
                         xlim = NULL)
vprofile_PARExtinction(x, SpParams, z = NULL, gdd = NA, draw = TRUE,
                       xlim = c(0,100))
vprofile_SWRExtinction(x, SpParams, z = NULL, gdd = NA, draw = TRUE,
                       xlim = c(0,100))
vprofile_windExtinction(x, SpParams, wind20H, z = NULL,  gdd = NA, draw = TRUE,
                        xlim = NULL)
}
\arguments{
  \item{x}{An object of class \code{\link{forest}}}
  \item{SpParams}{A data frame with species parameters (see \code{\link{SpParamsMED}}).}
  \item{z}{A numeric vector with height values.}
  \item{d}{A numeric vector with soil layer widths.}
  \item{gdd}{Growth degree days.}
  \item{byCohorts}{Separate profiles for each cohort.}
  \item{bySpecies}{Aggregate cohort profiles by species.}
  \item{wind20H}{The value of measured wind speed at 6 m = 20ft (in m/s).}
  \item{draw}{Logical flag to indicate that a plot is desired.}
  \item{xlim}{Limits of the x-axis.}
}
\value{ A numeric vector with values measured at each height. Units depend on the profile function:
\itemize{
\item{\code{vprofile_leafAreaDensity}: Cumulative LAI (m2/m2) per height bin.}
\item{\code{vprofile_fuelBulkDensity}: Fuel bulk density (kg/m3) per height bin.}
\item{\code{vprofile_PARExtinction}: Percent of photosynthetically active radiation (\%) corresponding to each height.}
\item{\code{vprofile_SWRExtinction}: Percent of shortwave radiation (\%) corresponding to each height.}
\item{\code{vprofile_windExtinction}: Wind speed (m/s) corresponding to each height.}
}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, Centre Tecnologic Forestal de Catalunya
}
\seealso{
\code{\link{forest}}
}
\examples{
#Default species parameterization
data(SpParamsMED)

#Load example plot plant data
data(exampleforest)

vprofile_leafAreaDensity(exampleforest, SpParamsMED)
vprofile_fuelBulkDensity(exampleforest, SpParamsMED)

vprofile_PARExtinction(exampleforest, SpParamsMED)
vprofile_SWRExtinction(exampleforest, SpParamsMED)

vprofile_windExtinction(exampleforest, SpParamsMED, 20)

}
