% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasError.R
\name{MeasError}
\alias{MeasError}
\title{Create a Measurement Error Object}
\usage{
MeasError(substitute, reference, replicate, differential)
}
\arguments{
\item{substitute}{a vector containing the error-prone measure}

\item{reference}{a vector containing the reference measure assumed without
measurement error}

\item{replicate}{a vector or matrix with replicates of the error-prone
measure with classical measurement error. This can either be
replicates obtained by using the same measurement method as the substitute
measure (replicates study) or replicates using a different measurement method
than the substitute measure (calibration study).}

\item{differential}{a vector containing the variable to which the measurement
error is differential.}
}
\value{
\code{MeasError} returns an object of \link[base]{class} "MeasError".

An object of class \code{MeasError} is a list containing the substitute and
reference (and replicate or differential if applicable) variables and has
attributes input (the name of the substitute and reference or replicate
and differential (if applicable) variables) and call (the matched call).
}
\description{
This function creates a measurement error object, usually used as a covariate
or the outcome in the \code{formula} argument of \link[mecor]{mecor} if one
wants to correct for the measurement error in that variable using a reference
variable or a replicate measure.
}
\examples{
## measurement error in a covariate:
# internal covariate-validation study
data(icvs)
with (icvs, MeasError(substitute = X_star,
                      reference = X))
# replicates study
data(rs)
with (rs, MeasError(substitute = X_star_1,
                    replicate = cbind(X_star_2, X_star_3)))
# covariate-calibration study
data(ccs)
with(ccs, MeasError(substitute = X_star,
                    replicate = cbind(X_star_1, X_star_2)))
## measurement error in the outcome:
# internal outcome-validation study
data(iovs)
with(iovs, MeasError(substitute = Y_star,
                     reference = Y))
# internal outcome- validation study with differential measurement error in
# the dependent variable
data(iovs_diff)
with(iovs_diff, MeasError(substitute = Y_star,
                          reference = Y,
                          differential = X))
}
\author{
Linda Nab, \email{l.nab@lumc.nl}
}
