% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustness.R
\name{robustness}
\alias{robustness}
\title{Calculate robustness across networks.}
\description{
This class is a wrapper for robustness calculation and visualization.
}
\examples{

## ------------------------------------------------
## Method `robustness$new`
## ------------------------------------------------

tmp <- robustness$new(soil_amp_network, remove_strategy = c("edge_rand"), 
  measure = c("Eff"), run = 3, remove_ratio = c(0.1, 0.5, 0.9))


## ------------------------------------------------
## Method `robustness$plot`
## ------------------------------------------------

\donttest{
tmp$plot(linewidth = 1)
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-robustness-new}{\code{robustness$new()}}
\item \href{#method-robustness-plot}{\code{robustness$plot()}}
\item \href{#method-robustness-clone}{\code{robustness$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-robustness-new"></a>}}
\if{latex}{\out{\hypertarget{method-robustness-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{robustness$new(
  network_list,
  remove_strategy = c("edge_rand", "edge_strong", "edge_weak", "node_rand", "node_hub",
    "node_degree_high", "node_degree_low")[1],
  remove_ratio = seq(0, 1, 0.1),
  measure = c("Eff", "Eigen", "Pcr")[1],
  run = 10
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{network_list}}{a list with multiple networks; all the networks should be \code{trans_network} object 
created from \code{\link{trans_network}} class of microeco package.}

\item{\code{remove_strategy}}{default "edge_rand"; 
\describe{
     \item{\strong{"edge_rand"}}{edges are randomly removed.}
  \item{\strong{"edge_strong"}}{edges are removed in decreasing order of weight.}
     \item{\strong{"edge_weak"}}{edges are removed in increasing order of weight.}
     \item{\strong{"node_rand"}}{nodes are removed randomly.}
     \item{\strong{"node_hub"}}{node hubs are removed. The hubs include network hubs and module hubs.}
     \item{\strong{"node_degree_high"}}{nodes are removed in decreasing order of degree.}
     \item{\strong{"node_degree_low"}}{nodes are removed in increasing order of degree.}
}}

\item{\code{remove_ratio}}{default seq(0, 1, 0.1).}

\item{\code{measure}}{default "Eff"; network robustness measures. 
\describe{
     \item{\strong{"Eff"}}{network efficiency. The average efficiency of the network is defined:
           \deqn{Eff = \frac{1}{N(N - 1)} \sum_{i \neq j \in G}\frac{1}{d(i, j)}}
          where N is the total number of nodes and \emph{d(i,j)} is the shortest path between node i and node j. 
          When the weight is found in the edge attributes, \eqn{d(i,j)} denotes the weighted shortest path between node i and node j.
          For more details, please read the references <doi: 10.1007/s11704-016-6108-z> and <doi: 10.1038/s41598-020-60298-7>.
          }
     \item{\strong{"Eigen"}}{natural connectivity <doi: 10.1007/s11704-016-6108-z>.
          The natural connectivity can be regarded as an average eigenvalue that changes strictly monotonically with the addition or deletion of edges. It is defined:
              \deqn{\bar{\lambda} = \ln(\frac{1}{N} \sum_{i=1}^{N} e^{\lambda~i~})}
          where \eqn{\lambda~i~} is the \eqn{i}th eigenvalue of the graph adjacency matrix. The larger the value of \eqn{\bar{\lambda}} is, the more robust the network is.
          }
     \item{\strong{"Pcr"}}{critical removal fraction of vertices (edges) for the disintegration of networks 
          <doi: 10.1007/s11704-016-6108-z> <doi: 10.1103/PhysRevE.72.056130>.
          This is a robustness measure based on random graph theory.
          The critical fraction against random attacks is labeled as \eqn{P_{c}^r}. It is defined:
              \deqn{P_{c}^r = 1 - \frac{1}{\frac{\langle k^2 \rangle}{\langle k \rangle} - 1}}
          where \eqn{\langle k \rangle} is the average nodal degree of the original network, and \eqn{\langle k^2 \rangle} is the average of square of nodal degree. 
          }
}}

\item{\code{run}}{default 10. Replication number applied for the sampling method.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_table}, stored in the object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{tmp <- robustness$new(soil_amp_network, remove_strategy = c("edge_rand"), 
  measure = c("Eff"), run = 3, remove_ratio = c(0.1, 0.5, 0.9))

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-robustness-plot"></a>}}
\if{latex}{\out{\hypertarget{method-robustness-plot}{}}}
\subsection{Method \code{plot()}}{
Plot the simulation results.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{robustness$plot(
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  show_point = TRUE,
  point_size = 1,
  point_alpha = 0.6,
  show_errorbar = TRUE,
  errorbar_position = position_dodge(0),
  errorbar_size = 1,
  errorbar_width = 0.1,
  add_fitting = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{color_values}}{colors used for presentation.}

\item{\code{show_point}}{default TRUE; whether show the point.}

\item{\code{point_size}}{default .3; point size value.}

\item{\code{point_alpha}}{default .6; point alpha value.}

\item{\code{show_errorbar}}{default TRUE; whether show the errorbar by using the SD result.}

\item{\code{errorbar_position}}{default position_dodge(0); Position adjustment, either as a string (such as "identity"), 
or the result of a call to a position adjustment function.}

\item{\code{errorbar_size}}{default 1; errorbar size.}

\item{\code{errorbar_width}}{default 0.1; errorbar width.}

\item{\code{add_fitting}}{default FALSE; whether add fitted smooth line. FALSE denotes add line segment among points.}

\item{\code{...}}{parameters pass to ggplot2::geom_line (when add_fitting = FALSE) or ggplot2::geom_smooth (when add_fitting = TRUE).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{ggplot}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
tmp$plot(linewidth = 1)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-robustness-clone"></a>}}
\if{latex}{\out{\hypertarget{method-robustness-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{robustness$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
