% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateGaussianDataset.R
\name{generateGaussianDataset}
\alias{generateGaussianDataset}
\title{Generate Gaussian dataset}
\usage{
generateGaussianDataset(
  cluster_means,
  std_dev,
  N,
  P,
  pi,
  row_names = paste0("Person_", seq(1, N)),
  col_names = paste0("Gene_", seq(1, P))
)
}
\arguments{
\item{cluster_means}{A k-vector of cluster means defining the k clusters.}

\item{std_dev}{A k-vector of cluster standard deviations defining the k clusters.}

\item{N}{The number of samples to generate in the entire dataset.}

\item{P}{The number of columns to generate in the dataset.}

\item{pi}{A k-vector of the expected proportion of points to be drawn from
each distribution.}

\item{row_names}{The row names of the generated dataset.}

\item{col_names}{The column names of the generated dataset.}
}
\value{
Named list of ``data``, the generated matrix and ``cluster_IDs``,
the generating structure.
}
\description{
Generate a dataset based upon a mixture of Gaussian distributions
(with independent features).
}
\examples{
cluster_means <- c(-2, 0, 2)
std_dev <- c(1, 1, 1.25)
N <- 100
P <- 5
pi <- c(0.3, 0.3, 0.4)
generateGaussianDataset(cluster_means, std_dev, N, P, pi)
}
