/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.core.utils;

import multidendrograms.core.definitions.Dendrogram;

public class SmartAxis {
    private double min;
    private double max;
    private double ticksSize;

    public SmartAxis(Dendrogram dendrogram, boolean bl) {
        this.min = this.getDendroMinHeight(dendrogram, bl);
        this.max = this.getDendroMaxHeight(dendrogram, bl);
        this.roundAxisLimits();
        this.roundTicks();
    }

    public double smartMin() {
        return this.min;
    }

    public double smartMax() {
        return this.max;
    }

    public double smartTicksSize() {
        return this.ticksSize;
    }

    private double getDendroMinHeight(Dendrogram dendrogram, boolean bl) {
        double d = dendrogram.getBandsMinHeight();
        double d2 = dendrogram.getNodesMinHeight();
        double d3 = Double.isNaN(d2) || bl ? d : Math.min(d, d2);
        if (dendrogram.isDistanceBased) {
            d3 = Math.min(d3, 0.0);
        }
        return d3;
    }

    private double getDendroMaxHeight(Dendrogram dendrogram, boolean bl) {
        double d = dendrogram.getBandsMaxHeight();
        double d2 = dendrogram.getNodesMaxHeight();
        double d3 = Double.isNaN(d2) || bl ? d : Math.max(d, d2);
        return d3;
    }

    private void roundAxisLimits() {
        int n;
        if (this.min == this.max) {
            switch (this.sign(this.min)) {
                case 0: {
                    this.min = -1.0;
                    this.max = 1.0;
                    break;
                }
                case 1: {
                    this.min /= 2.0;
                    this.max *= 2.0;
                    break;
                }
                case -1: {
                    this.min *= 2.0;
                    this.max /= 2.0;
                }
            }
        }
        if (this.sign(this.min) == this.sign(this.max)) {
            n = (int)(-Math.rint(Math.log10(Math.abs(2.0 * (this.max - this.min) / (this.max + this.min)))));
            n = Math.max(n, 0);
        } else {
            n = 0;
        }
        this.min = this.niceNum(this.min, n, NiceType.NICE_FLOOR);
        this.max = this.niceNum(this.max, n, NiceType.NICE_CEIL);
        if (this.sign(this.min) == this.sign(this.max)) {
            if (this.max / this.min > 5.0) {
                this.min = 0.0;
            } else if (this.min / this.max > 5.0) {
                this.max = 0.0;
            }
        }
    }

    private void roundTicks() {
        this.ticksSize = this.niceNum((this.max - this.min) / 9.0, 0, NiceType.NICE_ROUND);
    }

    private double niceNum(double d, int n, NiceType niceType) {
        if (d == 0.0) {
            return 0.0;
        }
        long l = this.sign(d);
        d = Math.abs(d);
        double d2 = Math.floor(Math.log10(d)) - (double)n;
        double d3 = d / Math.pow(10.0, d2) / 10.0;
        double d4 = Math.floor(d3);
        double d5 = 10.0 * (d3 - d4);
        double d6 = niceType == NiceType.NICE_FLOOR && l == 1L || niceType == NiceType.NICE_CEIL && l == -1L ? (double)((int)Math.floor(d5)) : (niceType == NiceType.NICE_FLOOR && l == -1L || niceType == NiceType.NICE_CEIL && l == 1L ? (double)((int)Math.ceil(d5)) : (d5 < 1.5 ? 1.0 : (d5 < 3.0 ? 2.0 : (d5 < 7.0 ? 5.0 : 10.0))));
        d3 = d4 + d6 / 10.0;
        return (double)l * d3 * 10.0 * Math.pow(10.0, d2);
    }

    private int sign(double d) {
        return (int)Math.round(Math.signum(d));
    }

    private static enum NiceType {
        NICE_FLOOR,
        NICE_CEIL,
        NICE_ROUND;

    }
}

