% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_as_na_if.R
\name{recode_as_na_if}
\alias{recode_as_na_if}
\title{Conditionally change all column values to NA}
\usage{
recode_as_na_if(df, sign = "gteq", percent_na = 50, keep_columns = NULL, ...)
}
\arguments{
\item{df}{A data.frame object}

\item{sign}{Character. One of gteq,lteq,lt,gt or eq which refer to greater 
than(gt) or equal(eq) or
less than(lt) or equal to(eq) respectively.}

\item{percent_na}{The percentage to use when dropping columns with missing 
values}

\item{keep_columns}{Columns that should be kept despite meeting the target 
percent_na 
criterion(criteria)}

\item{...}{Other arguments to "percent_missing"}
}
\value{
A `data.frame` with the target columns populated with `NA`s.
}
\description{
Conditionally change all column values to NA
}
\examples{
head(recode_as_na_if(airquality, sign="gt", percent_na=20))
}
