% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.R
\name{prep.msc}
\alias{prep.msc}
\title{Multiplicative Scatter Correction transformation}
\usage{
prep.msc(spectra, mspectrum = NULL)
}
\arguments{
\item{spectra}{a matrix with spectra values}

\item{mspectrum}{mean spectrum (if NULL will be calculated from \code{spectra})}
}
\value{
preprocessed spectra (calculated mean spectrum is assigned as attribut 'mspectrum')
}
\description{
Applies Multiplicative Scatter Correction (MSC) transformation to data matrix (spectra)
}
\details{
MSC is used to remove scatter effects (baseline offset and slope) from
spectral data, e.g. NIR spectra.

 @examples

 ### Apply MSC to spectra from simdata

 library(mdatools)
 data(simdata)

 spectra = simdata$spectra.c
 cspectra = prep.msc(spectra)

 par(mfrow = c(2, 1))
 mdaplot(spectra, type = "l", main = "Before MSC")
 mdaplot(cspectra, type = "l", main = "After MSC")
}
