% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariateAnalysis.R
\name{univariateAnalysis}
\alias{univariateAnalysis}
\title{A univariateAnalysis Function}
\usage{
univariateAnalysis(
  dat,
  hist = FALSE,
  boxplot = FALSE,
  qqnorm = FALSE,
  shapiro = FALSE
)
}
\arguments{
\item{dat}{Data in data frame format.}

\item{hist}{A plot of histogram}

\item{boxplot}{A box plot showing distribution of the variable}

\item{qqnorm}{A qnantile quantile plot}

\item{shapiro}{A  Shapiro-Wilk normality test.}
}
\value{
Returns either a historgram, box-plot, q-q plot or Shapiro-Wilk statistic .
}
\description{
'univariateAnalysis' produces univariate plots such as histogram, box plot and  q-q plot. It also calculates
the Shapiro-Wilk statistic for numeric data.
}
\examples{
data(iris)
univariateAnalysis (iris[,-5], qqnorm  = TRUE)
}
\author{
Henry  Nanji, Saisakul Chernbumroong
}
\keyword{analysis}
\keyword{univariate}
