% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcpmap.R
\name{mcpmap}
\alias{mcpmap}
\title{Parallel Map Over Lists Using Multiple Cores}
\usage{
mcpmap(lists, func, num_cores = parallel::detectCores() - 1)
}
\arguments{
\item{lists}{A list of lists where each inner list contains the arguments to be passed to the function `func`.
Each inner list should correspond to an argument of `func`, and all lists must have the same length.}

\item{func}{The function to apply to each set of arguments contained in `lists`.}

\item{num_cores}{The number of cores to use for parallel execution, defaulting to the number of cores
available on the system minus one. On Windows, due to lack of support for multicore execution using
forking, the default is set to 1.}
}
\value{
A list of results, each element being the result from applying `func` to the corresponding elements
of the input lists.
}
\description{
This function applies a given function in parallel over elements of a list.
It uses `parallel::mcmapply` on Unix-like systems and `parallel::parLapply` on Windows.
This approach ensures cross-platform compatibility.
}
\examples{
sum_func <- function(x, y) x + y
args_list <- list(c(1, 2, 3), c(4, 5, 6))
results <- mcpmap(args_list, sum_func, num_cores = 2)
}
\seealso{
\code{\link[parallel]{mcmapply}}, \code{\link[parallel]{parLapply}}
}
