% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{computeDesignMatrix}
\alias{computeDesignMatrix}
\title{Compute list of design matrices for all terms in a model formula}
\usage{
computeDesignMatrix(formula, data)
}
\arguments{
\item{formula}{model formula.}

\item{data}{data frame to be used in deriving the design matrices.}
}
\value{
A list of design matrices.
}
\description{
The output is a list of dense or sparse design matrices for the specified model components with respect to
\code{data}. The design matrices contain appropriate column names.
}
\examples{
n <- 1000
dat <- data.frame(
  x = rnorm(n),
  f = factor(sample(1:50, n, replace=TRUE))
)
str(X <- computeDesignMatrix(~ x, dat)[[1]])
X <- computeDesignMatrix(
  ~ reg(~x, name="beta") + gen(~x, factor=~f, name="v"), dat
)
str(X)

}
