% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-nlist.R
\name{as_nlist.mcmcr}
\alias{as_nlist.mcmcr}
\title{Coerce to nlist}
\usage{
\method{as_nlist}{mcmcr}(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Unused.}
}
\value{
An nlist object.
}
\description{
Coerce an R object to an \code{\link[nlist:nlist]{nlist_object()}}.
}
\section{Methods (by class)}{

\itemize{
\item \code{numeric}: Coerce named numeric vector to nlist

\item \code{list}: Coerce list to nlist

\item \code{data.frame}: Coerce data.frame to nlist

\item \code{mcmc}: Coerce mcmc (with one iteration) to nlist

\item \code{mcmc.list}: Coerce mcmc.list (with one iteration) to nlist
}
}

\examples{
as_nlist(list(x = 1:4))
as_nlist(c(`a[2]` = 3, `a[1]` = 2))
}
