% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{subset}
\alias{subset}
\alias{subset.mcmc}
\alias{subset.mcmc.list}
\alias{subset.mcmcarray}
\alias{subset.mcmcr}
\alias{subset.mcmcrs}
\title{Subset an MCMC Object}
\usage{
\method{subset}{mcmc}(x, iters = NULL, pars = NULL, iterations = NULL, parameters = NULL, ...)

\method{subset}{mcmc.list}(
  x,
  chains = NULL,
  iters = NULL,
  pars = NULL,
  iterations = NULL,
  parameters = NULL,
  ...
)

\method{subset}{mcmcarray}(x, chains = NULL, iters = NULL, iterations = NULL, ...)

\method{subset}{mcmcr}(
  x,
  chains = NULL,
  iters = NULL,
  pars = NULL,
  iterations = NULL,
  parameters = NULL,
  ...
)

\method{subset}{mcmcrs}(
  x,
  chains = NULL,
  iters = NULL,
  pars = NULL,
  iterations = NULL,
  parameters = NULL,
  ...
)
}
\arguments{
\item{x}{The MCMC object to subset}

\item{iters}{An integer vector of iterations.}

\item{pars}{A character vector of parameter names.}

\item{iterations}{An integer vector (or NULL) of the iterations to subset by.}

\item{parameters}{A character vector (or NULL) of the parameters to subset by.}

\item{...}{Unused.}

\item{chains}{An integer vector of chains.}
}
\description{
Subsets an MCMC object by its chains, iterations and/or parameters.
}
\section{Methods (by class)}{
\itemize{
\item \code{mcmc}: Subset an mcmc object

\item \code{mcmc.list}: Subset an mcmc.list object

\item \code{mcmcarray}: Subset an mcmcarray object

\item \code{mcmcr}: Subset an mcmcr object

\item \code{mcmcrs}: Subset an mcmcrs object
}}

\examples{
subset(mcmcr_example,
  chains = 2L, iters = 1:100,
  pars = c("beta", "alpha")
)
}
