% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_dists.R
\name{find_dists}
\alias{find_dists}
\title{Calculate (signed) distances between coordinates}
\usage{
find_dists(locations, longlat = TRUE)
}
\arguments{
\item{locations}{A matrix or data.frame of 2D points, the first column is
x/longitude, and the second column is y/latitude.}

\item{longlat}{Logical, if TURE Great Circle (WGS84 ellipsoid) distance;
if FALSE, Euclidean distance.}
}
\value{
List of signed distances.
}
\description{
Calculate (signed) distances between coordinates
}
\details{
\code{locations} must be a matrix or data.frame containing 2 columns,
first column x/longitude, and second column y/latitude.The row names of
\code{locations} are used as the names of the locations.
}
\examples{
lon <- c(110, 120, 130)
lat <- c(50, 55, 60)
locations <- cbind(lon, lat)
rownames(locations) <- paste("Site", 1:3)
find_dists(locations)
}
