% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acfs.R
\name{acf_rs}
\alias{acf_rs}
\title{Calculate regime-switching auto-correlation}
\usage{
acf_rs(x, label, lag_max, demean = TRUE)
}
\arguments{
\item{x}{A univariate numeric time series.}

\item{label}{A factor of regime labels.}

\item{lag_max}{Maximum lag at which to calculate the acf.}

\item{demean}{Logical. Should the covariances be about the sample means?}
}
\value{
Mean auto-correlations for each group in \code{label}.
}
\description{
Calculate regime-switching auto-correlation
}
\examples{
set.seed(123)
x <- rnorm(100)
label <- sample(1:2, 100, replace = TRUE)
acf_rs(x, label = factor(label), lag_max = 3)
}
