% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vif.R
\name{vif_covariate_select}
\alias{vif_covariate_select}
\title{Run variance inflation factor (VIF) selection on input covariates}
\usage{
vif_covariate_select(dataset, vif_cutoff = 5)
}
\arguments{
\item{dataset}{data.frame-like object with named columns containing all covariates to
consider in the VIF analysis.}

\item{vif_cutoff}{(\code{numeric(1)}) Cutoff for maximum variance inflation factor in
\code{dataset}}
}
\value{
data.table listing each variable, VIF in most recent round, and whether the
indicator should be included or not
}
\description{
Run variance inflation factor (VIF) selection on input covariates
}
