% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Make.Tree.R
\name{Make.Decision.Tree}
\alias{Make.Decision.Tree}
\title{Evaluate utilities}
\usage{
Make.Decision.Tree(tree.data)
}
\arguments{
\item{tree.data}{data.table with decision tree information}
}
\value{
igraph object
}
\description{
Create decision tree for MAUT models exporting to an igraph object
}
\details{
Details

With the tree information loaded by the \code{\link{Read.Tree}} the decision tree
could be represented like an igraph object.
}
\examples{
library( data.table )
library( igraph )
file<-system.file("extdata", "tree.csv", package = "mau" )
tree.data<-Read.Tree( file, skip = 0, nrows = 8 )
tree<-Make.Decision.Tree( tree.data )
plot( tree )
}
\author{
Pedro Guarderas, Andrés Lopez
}
\seealso{
\code{\link{Read.Tree}}
}

