% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{add_UKEnergy2000_matnames}
\alias{add_UKEnergy2000_matnames}
\title{Add a column of matrix names to tidy data frame}
\usage{
add_UKEnergy2000_matnames(.DF, ledger_side_colname = "Ledger.side",
  energy_colname = "E.ktoe", supply_side = "Supply",
  consumption_side = "Consumption", matname_colname = "matname",
  U_name = "U", V_name = "V", Y_name = "Y")
}
\arguments{
\item{.DF}{a data frame with \code{ledger_side_colname} and \code{energy_colname}.}

\item{ledger_side_colname}{the name of the column in \code{.DF} that contains ledger side
(a string). Default is "\code{Ledger.side}".}

\item{energy_colname}{the name of the column in \code{.DF} that contains energy values
(a string). Default is "\code{E.ktoe}".}

\item{supply_side}{the identifier for items on the supply side of the ledger (a string).
Default is "\code{Supply}".}

\item{consumption_side}{the identifier for items on the consumption side
of the ledger (a string). Default is "\code{Consumption}".}

\item{matname_colname}{the name of the output column containing the name of the matrix
in which this row belongs (a string). Default is "\code{UVY}".}

\item{U_name}{the name for the use matrix (a string). Default is "\code{U}".}

\item{V_name}{the name for the make matrix (a string). Default is "\code{V}".}

\item{Y_name}{the name for the final demand matrix (a string). Default is "\code{Y}".}
}
\value{
\code{.DF} with an added column, \code{UVY_colname}.
}
\description{
Add a column of matrix names to tidy data frame
}
\examples{
matsindf:::add_UKEnergy2000_matnames(UKEnergy2000)
}
