% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Special_matrices.R
\name{special.matrix}
\alias{special.matrix}
\alias{I}
\alias{J}
\title{Generating Special Matrices}
\usage{
I(n)

J(n, m = n)
}
\arguments{
\item{n}{Number of rows in \emph{I} or \emph{J}.}

\item{m}{Number of columns in \emph{J}. Default: Same as number of rows.}
}
\description{
Creates an Identity Matrix \emph{I} and a Matrix of Ones \emph{J}. \itemize{
\item \code{I}(): Creates an identity matrix where the number of columns is n.  This is a diagonal matrix with all equal to one (1). An identity matrix is usually written as \emph{I}. Names of rows and columns (\code{dimnames}) are included.
\item \code{J}(): Creates a matrix of ones with any number of rows and columns. Names of rows and columns (\code{dimnames}) are included.
}
}
\examples{
# To create an identity matrix of order 12
I(2)
# To make a matrix of 6 rows and 10 columns of all ones
J(6, 10)
# To make a matrix of unity, dimensions 6 x 6.
J(6)
}
\seealso{
Other matrix: 
\code{\link{tr}()},
\code{\link{vec}()}
}
\concept{matrix}
\keyword{identity}
\keyword{matrix}
\keyword{ones}
