% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{partial_correlation_cpp}
\alias{partial_correlation_cpp}
\title{Partial correlation matrix with sample / ridge / OAS covariance}
\usage{
partial_correlation_cpp(
  X_,
  method = "oas",
  lambda = 0.001,
  return_cov_precision = TRUE
)
}
\arguments{
\item{X_}{Numeric double matrix (n x p). No NAs.}

\item{method}{One of "sample", "ridge", "oas". Default "oas" (recommended for p >> n).}

\item{lambda}{Ridge penalty for "ridge" method (added to diagonal). Ignored otherwise.}

\item{return_cov_precision}{If TRUE, return covariance and precision matrices.}
}
\value{
A list with elements: \code{pcor}, and optionally \code{cov}, \code{precision},
\code{method}, \code{lambda}, \code{rho} (for OAS).
}
\description{
Partial correlation matrix with sample / ridge / OAS covariance
}
